/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.Couple;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;

public class GrMapTypeImpl
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, PsiType> myStringEntries;
    @NotNull
    private final List<Couple<PsiType>> myOtherEntries;

    GrMapTypeImpl(JavaPsiFacade facade, GlobalSearchScope scope, @NotNull LinkedHashMap<String, PsiType> stringEntries, @NotNull List<Couple<PsiType>> otherEntries, @NotNull LanguageLevel languageLevel) {
        super(facade, scope, languageLevel);
        this.myStringEntries = stringEntries;
        this.myOtherEntries = otherEntries;
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        return this.myStringEntries.get(key);
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        return this.myStringEntries.keySet();
    }

    @Override
    @NotNull
    protected PsiType[] getAllKeyTypes() {
        HashSet<Object> result2 = new HashSet<Object>();
        if (!this.myStringEntries.isEmpty()) {
            result2.add(GroovyPsiManager.getInstance(this.myFacade.getProject()).createTypeByFQClassName("java.lang.String", this.getResolveScope()));
        }
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result2.add(entry.first);
        }
        result2.remove(null);
        return result2.toArray(GrMapTypeImpl.createArray((int)result2.size()));
    }

    @Override
    @NotNull
    protected PsiType[] getAllValueTypes() {
        HashSet<PsiType> result2 = new HashSet<PsiType>(this.myStringEntries.values());
        for (Couple<PsiType> entry : this.myOtherEntries) {
            result2.add((PsiType)entry.second);
        }
        result2.remove(null);
        return result2.toArray(GrMapTypeImpl.createArray((int)result2.size()));
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        return this.myOtherEntries;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        return this.myStringEntries;
    }

    public boolean isValid() {
        for (PsiType psiType : this.myStringEntries.values()) {
            if (psiType == null || psiType.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (couple.first != null && !((PsiType)couple.first).isValid()) {
                return false;
            }
            if (couple.second == null || ((PsiType)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeImpl type2 = (GrMapTypeImpl)((Object)o);
        if (!this.myStringEntries.equals(type2.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(type2.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }
}

