/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapImpl
extends GrExpressionImpl
implements GrListOrMap,
PsiListLikeElement {
    private static final TokenSet MAP_LITERAL_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.NAMED_ARGUMENT, GroovyTokenTypes.mCOLON});
    private final PsiReference myLiteralReference = new LiteralConstructorReference(this);
    private volatile GrExpression[] myInitializers;
    private volatile GrNamedArgument[] myNamedArguments;

    public GrListOrMapImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitListOrMap(this);
    }

    public String toString() {
        return "Generalized list";
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (this.getInitializers().length == 0) {
            return super.addInternal(first, last, this.getNode().getFirstChildNode(), Boolean.valueOf(false));
        }
        ASTNode lastChild = this.getNode().getLastChildNode();
        this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", lastChild);
        return super.addInternal(first, last, lastChild.getTreePrev(), Boolean.valueOf(false));
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi = child.getPsi();
        if (psi instanceof GrExpression || psi instanceof GrNamedArgument) {
            PsiElement prev = PsiUtil.getPrevNonSpace(psi);
            PsiElement next = PsiUtil.getNextNonSpace(psi);
            if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(prev.getNode());
            } else if (next instanceof LeafPsiElement && next.getNode() != null && next.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                super.deleteChildInternal(next.getNode());
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public boolean isMap() {
        return this.findChildByType(MAP_LITERAL_TOKEN_SET) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.getInitializers().length == 0 && this.getNamedArguments().length == 0;
    }

    @Override
    public PsiElement getLBrack() {
        return this.findChildByType(GroovyTokenTypes.mLBRACK);
    }

    @Override
    public PsiElement getRBrack() {
        return this.findChildByType(GroovyTokenTypes.mRBRACK);
    }

    @Override
    @NotNull
    public GrExpression[] getInitializers() {
        GrExpression[] initializers = this.myInitializers;
        if (initializers == null) {
            initializers = (GrExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrExpression.class);
            initializers = initializers == null ? GrExpression.EMPTY_ARRAY : initializers;
            this.myInitializers = initializers;
        }
        return initializers;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] namedArguments = this.myNamedArguments;
        if (namedArguments == null) {
            namedArguments = (GrNamedArgument[])PsiTreeUtil.getChildrenOfType((PsiElement)this, GrNamedArgument.class);
            namedArguments = namedArguments == null ? GrNamedArgument.EMPTY_ARRAY : namedArguments;
            this.myNamedArguments = namedArguments;
        }
        return namedArguments;
    }

    @Override
    public GrNamedArgument findNamedArgument(@NotNull String label) {
        return PsiImplUtil.findNamedArgument(this, label);
    }

    public PsiReference getReference() {
        return this.myLiteralReference;
    }

    public void subtreeChanged() {
        this.myInitializers = null;
        this.myNamedArguments = null;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        return PsiTreeUtil.getChildrenOfAnyType((PsiElement)this, (Class[])new Class[]{GrExpression.class, GrNamedArgument.class});
    }
}

