/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureParameterImpl;

class GrFunctionalExpressionSignature
implements GrSignature {
    @NotNull
    private final GrFunctionalExpression myExpression;

    GrFunctionalExpressionSignature(@NotNull GrFunctionalExpression expression) {
        this.myExpression = expression;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return PsiSubstitutor.EMPTY;
    }

    @Override
    @NotNull
    public GrClosureParameter[] getParameters() {
        Object[] parameters = this.myExpression.getAllParameters();
        return (GrClosureParameter[])ContainerUtil.map((Object[])parameters, parameter -> this.createClosureParameter((GrParameter)parameter), (Object[])new GrClosureParameter[parameters.length]);
    }

    @NotNull
    protected GrClosureParameter createClosureParameter(@NotNull GrParameter parameter) {
        return new GrClosureParameterImpl(parameter);
    }

    @Override
    public int getParameterCount() {
        return this.myExpression.getAllParameters().length;
    }

    @Override
    public boolean isVarargs() {
        GrParameter last = (GrParameter)ArrayUtil.getLastElement((Object[])this.myExpression.getAllParameters());
        return last != null && last.getType() instanceof PsiArrayType;
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return this.myExpression.getReturnType();
    }

    @Override
    public boolean isCurried() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myExpression.isValid();
    }
}

