/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrCallImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrConstructorInvocationReference;

public class GrConstructorInvocationImpl
extends GrCallImpl
implements GrConstructorInvocation {
    private final GroovyCallReference myConstructorReference = new GrConstructorInvocationReference(this);

    public GrConstructorInvocationImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitConstructorInvocation(this);
    }

    public String toString() {
        return "Constructor invocation";
    }

    @Override
    @NotNull
    public GroovyCallReference getConstructorReference() {
        return this.myConstructorReference;
    }

    @Override
    public boolean isSuperCall() {
        return this.getKeywordType() == GroovyTokenTypes.kSUPER;
    }

    @Override
    public boolean isThisCall() {
        return this.getKeywordType() == GroovyTokenTypes.kTHIS;
    }

    @Nullable
    private IElementType getKeywordType() {
        GrReferenceExpression keyword = this.getInvokedExpression();
        PsiElement refElement = keyword.getReferenceNameElement();
        if (refElement == null) {
            return null;
        }
        return refElement.getNode().getElementType();
    }

    @Override
    @NotNull
    public GrReferenceExpression getInvokedExpression() {
        return (GrReferenceExpression)this.findNotNullChildByClass(GrReferenceExpression.class);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return this.myConstructorReference.multiResolve(incompleteCode);
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        PsiClass aClass = this.getDelegatedClass();
        if (aClass == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return new GroovyResolveResult[]{new GroovyResolveResultImpl((PsiElement)aClass, this, null, PsiSubstitutor.EMPTY, true, true)};
    }

    @Override
    @Nullable
    public PsiClass getDelegatedClass() {
        PsiClass typeDefinition = PsiUtil.getContextClass(this);
        if (typeDefinition != null) {
            return this.isThisCall() ? typeDefinition : typeDefinition.getSuperClass();
        }
        return null;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        return this.multiResolve(true);
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
    }
}

