/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrFieldImpl
extends GrVariableBaseImpl<GrFieldStub>
implements GrField,
StubBasedPsiElement<GrFieldStub> {
    public GrFieldImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrFieldImpl(GrFieldStub stub) {
        this(stub, (IStubElementType)GroovyStubElementTypes.FIELD);
    }

    public GrFieldImpl(GrFieldStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitField(this);
    }

    public String toString() {
        return "Field";
    }

    @Override
    public PsiExpression getInitializer() {
        return PsiImplUtil.getOrCreatePisExpression(this.getInitializerGroovy());
    }

    public void setInitializer(@Nullable PsiExpression psiExpression) throws IncorrectOperationException {
        GrExpression oldInitializer = this.getInitializerGroovy();
        if (psiExpression == null) {
            if (oldInitializer != null) {
                oldInitializer.delete();
                PsiElement assign = this.findChildByType(GroovyTokenTypes.mASSIGN);
                if (assign != null) {
                    assign.delete();
                }
            }
            return;
        }
        GrExpression newInitializer = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionFromText(psiExpression.getText());
        if (oldInitializer != null) {
            oldInitializer.replaceWithExpression(newInitializer, true);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", this.getNode().getLastChildNode());
            this.addAfter(newInitializer, this.getLastChild());
        }
    }

    @Override
    public boolean isDeprecated() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDocTag() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @Override
    public PsiType getTypeGroovy() {
        PsiType type2 = (PsiType)TypeInferenceHelper.inTopContext(() -> GroovyPsiManager.getInstance(this.getProject()).getType(this, field -> {
            PsiType type1;
            if (this.getDeclaredType() == null && this.getInitializerGroovy() == null && (type1 = GrVariableEnhancer.getEnhancedType(field)) != null) {
                return type1;
            }
            return null;
        }));
        if (type2 != null) {
            return type2;
        }
        return (PsiType)TypeInferenceHelper.inTopContext(() -> super.getTypeGroovy());
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent2 = this.getParent().getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (pparent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    public boolean isProperty() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            return stub.isProperty();
        }
        return PsiUtil.isProperty(this);
    }

    @Override
    @Nullable
    public GrAccessorMethod getSetter() {
        return GrClassImplUtil.findSetter(this);
    }

    @Override
    @NotNull
    public GrAccessorMethod[] getGetters() {
        return GrClassImplUtil.findGetters(this);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.isProperty()) {
            return ResolveScopeManager.getElementUseScope((PsiElement)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getFieldPresentation((PsiField)this);
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        boolean isAbstract = this.hasModifierProperty("abstract");
        Icon fieldIcon = this.isProperty() ? (isAbstract ? JetgroovyIcons.Groovy.AbstractProperty : JetgroovyIcons.Groovy.Property) : (isAbstract ? JetgroovyIcons.Groovy.AbstractField : JetgroovyIcons.Groovy.Field);
        return ElementPresentationUtil.createLayeredIcon((Icon)fieldIcon, (PsiModifierListOwner)this, (boolean)false);
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrFieldStub stub = (GrFieldStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                return Collections.emptyMap();
            }
            HashMap result2 = ContainerUtil.newHashMap();
            for (String parameter : namedParameters) {
                result2.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            return result2;
        }
        return GrNamedArgumentSearchVisitor.find(this);
    }

    @Override
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }
}

