/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.FunctionalExpressionsKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks.GrBlockImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.params.GrParameterListImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.ClosureSyntheticParameter;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;

public class GrClosableBlockImpl
extends GrBlockImpl
implements GrClosableBlock {
    private final AtomicReference<GrParameter[]> mySyntheticItParameter = new AtomicReference();
    private static final Function<GrClosableBlock, PsiType> ourTypesCalculator = block -> GroovyPsiManager.inferType(block, new MethodTypeInferencer((GrStatementOwner)block));

    public GrClosableBlockImpl(@NotNull IElementType type2, CharSequence buffer) {
        super(type2, buffer);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitClosure(this);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.mySyntheticItParameter.set(null);
    }

    @Override
    public boolean processClosureDeclarations(@NotNull PsiScopeProcessor plainProcessor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return FunctionalExpressionsKt.processDeclarationsWithCallsite(this, plainProcessor, state, lastParent, place);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent == null) {
            return true;
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!FunctionalExpressionsKt.processParameters(this, processor, state)) {
            return false;
        }
        return FunctionalExpressionsKt.processClosureClassMembers(this, processor, state, lastParent, place);
    }

    public String toString() {
        return "Closable block";
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        if (this.hasParametersSection()) {
            GrParameterListImpl parameterList = this.getParameterList();
            return parameterList.getParameters();
        }
        return GrParameter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrParameter[] getAllParameters() {
        if (this.hasParametersSection()) {
            return this.getParameters();
        }
        return this.getSyntheticItParameter();
    }

    @Override
    @Nullable
    public PsiElement getArrow() {
        return this.findPsiChildByType(GroovyTokenTypes.mCLOSABLE_BLOCK_OP);
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @Override
    @NotNull
    public GrParameterListImpl getParameterList() {
        GrParameterListImpl childByClass = (GrParameterListImpl)this.findChildByClass(GrParameterListImpl.class);
        assert (childByClass != null);
        return childByClass;
    }

    @Override
    public GrParameter addParameter(GrParameter parameter) {
        GrParameterListImpl parameterList = this.getParameterList();
        if (this.getArrow() == null) {
            GrParameterList newParamList = (GrParameterList)this.addAfter(parameterList, this.getLBrace());
            parameterList.delete();
            ASTNode next = newParamList.getNode().getTreeNext();
            this.getNode().addLeaf(GroovyTokenTypes.mCLOSABLE_BLOCK_OP, (CharSequence)"->", next);
            return (GrParameter)newParamList.add(parameter);
        }
        return (GrParameter)parameterList.add(parameter);
    }

    @Override
    public boolean hasParametersSection() {
        return this.getArrow() != null;
    }

    @Override
    public PsiType getType() {
        return GrClosureType.create(this, true);
    }

    @Override
    @Nullable
    public PsiType getNominalType() {
        return this.getType();
    }

    public GrParameter[] getSyntheticItParameter() {
        if (this.getParent() instanceof GrStringInjection) {
            return GrParameter.EMPTY_ARRAY;
        }
        return this.mySyntheticItParameter.updateAndGet(value -> {
            GrParameter[] grParameterArray;
            if (value == null) {
                GrParameter[] grParameterArray2 = new GrParameter[1];
                grParameterArray = grParameterArray2;
                grParameterArray2[0] = new ClosureSyntheticParameter(this, true);
            } else {
                grParameterArray = value;
            }
            return grParameterArray;
        });
    }

    @Override
    @Nullable
    public PsiType getOwnerType() {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)FunctionalExpressionsKt.doGetOwnerType(this), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Override
    public GrExpression replaceWithExpression(@NotNull GrExpression newExpr, boolean removeUnnecessaryParentheses) {
        return PsiImplUtil.replaceExpression(this, newExpr, removeUnnecessaryParentheses);
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, ourTypesCalculator);
    }

    @Override
    public void removeStatement() throws IncorrectOperationException {
        GroovyPsiElementImpl.removeStatement(this);
    }

    @Override
    public boolean isTopControlFlowOwner() {
        return !(this.getParent() instanceof GrStringInjection);
    }

    @Override
    @NotNull
    public PsiElement getLBrace() {
        return Objects.requireNonNull(super.getLBrace());
    }
}

