/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.clauses;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GrCaseSectionImpl
extends GroovyPsiElementImpl
implements GrCaseSection {
    public GrCaseSectionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitCaseSection(this);
    }

    public String toString() {
        return "Case section";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        return ResolveUtilKt.processLocals(this, processor, state, lastParent, place);
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    @Override
    @NotNull
    public GrCaseLabel[] getCaseLabels() {
        List labels = this.findChildrenByType(GroovyElementTypes.CASE_LABEL);
        return labels.toArray(new GrCaseLabel[0]);
    }

    @Override
    public boolean isDefault() {
        List labels = this.findChildrenByType(GroovyElementTypes.CASE_LABEL);
        for (GrCaseLabel label : labels) {
            if (!label.isDefault()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        return PsiImplUtil.getStatements(this);
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement element, @Nullable GrStatement anchor) throws IncorrectOperationException {
        ASTNode elemNode = element.copy().getNode();
        assert (elemNode != null);
        ASTNode anchorNode = anchor != null ? anchor.getNode() : null;
        this.getNode().addChild(elemNode, anchorNode);
        if (this.mayUseNewLinesAsSeparators()) {
            this.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", anchorNode);
        } else {
            this.getNode().addLeaf(GroovyTokenTypes.mSEMI, (CharSequence)";", anchorNode);
        }
        return (GrStatement)elemNode.getPsi();
    }

    private boolean mayUseNewLinesAsSeparators() {
        for (GrCaseSectionImpl parent2 = this; parent2 != null; parent2 = parent2.getParent()) {
            if (!(parent2 instanceof GrString)) continue;
            GrString grString = (GrString)((Object)parent2);
            return !grString.isPlainString();
        }
        return true;
    }
}

