/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrNewExpressionReference;

public class GrNewExpressionImpl
extends GrCallExpressionImpl
implements GrNewExpression {
    private final Lazy<GroovyCallReference> myConstructorReference = LazyKt.lazy(() -> this.getArrayCount() > 0 || this.getReferenceElement() == null ? null : new GrNewExpressionReference(this));

    public GrNewExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "NEW expression";
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitNewExpression(this);
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        if (list == null) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrArgumentList newList = factory.createExpressionArgumentList(new GrExpression[0]);
            PsiElement anchor = GrNewExpressionImpl.findAnchor(this);
            ASTNode anchorNode = anchor.getNode();
            assert (anchorNode != null);
            this.getNode().addChild(newList.getNode(), anchorNode);
        }
        return super.addNamedArgument(namedArgument);
    }

    @NotNull
    private static PsiElement findAnchor(@NotNull PsiElement element) {
        PsiElement prevSibling;
        PsiElement last = element.getLastChild();
        assert (last != null);
        while ((prevSibling = last.getPrevSibling()) instanceof PsiWhiteSpace || prevSibling instanceof PsiErrorElement) {
            last = prevSibling;
        }
        return last;
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getArgumentListGroovy();
        }
        return super.getArgumentList();
    }

    @Override
    public GrCodeReferenceElement getReferenceElement() {
        GrAnonymousClassDefinition anonymous = this.getAnonymousClassDefinition();
        if (anonymous != null) {
            return anonymous.getBaseClassReferenceGroovy();
        }
        return (GrCodeReferenceElement)this.findChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        GrCodeReferenceElement referenceElement = this.getReferenceElement();
        if (referenceElement != null) {
            return referenceElement.multiResolve(false);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    @Override
    public int getArrayCount() {
        GrArrayDeclaration arrayDeclaration = this.getArrayDeclaration();
        if (arrayDeclaration == null) {
            return 0;
        }
        return arrayDeclaration.getArrayCount();
    }

    @Override
    public GrAnonymousClassDefinition getAnonymousClassDefinition() {
        return (GrAnonymousClassDefinition)this.findChildByClass(GrAnonymousClassDefinition.class);
    }

    @Override
    @Nullable
    public GrArrayDeclaration getArrayDeclaration() {
        return (GrArrayDeclaration)this.findChildByClass(GrArrayDeclaration.class);
    }

    @Override
    @Nullable
    public GrArrayInitializer getArrayInitializer() {
        return (GrArrayInitializer)this.findChildByClass(GrArrayInitializer.class);
    }

    @Override
    @Nullable
    public GrTypeArgumentList getConstructorTypeArguments() {
        return (GrTypeArgumentList)this.findChildByClass(GrTypeArgumentList.class);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        return this.multiResolve(true);
    }

    @Override
    public GrTypeElement getTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyCallReference reference = this.getConstructorReference();
        return reference == null ? GroovyResolveResult.EMPTY_ARRAY : reference.multiResolve(incompleteCode);
    }

    @Override
    @Nullable
    public GroovyCallReference getConstructorReference() {
        return (GroovyCallReference)this.myConstructorReference.getValue();
    }
}

