/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrAbstractLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralEscaper;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrLiteralImpl
extends GrAbstractLiteral
implements GrLiteral,
PsiLanguageInjectionHost {
    private static final Logger LOG = Logger.getInstance(GrLiteralImpl.class);

    public GrLiteralImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Literal";
    }

    @Override
    public PsiType getType() {
        IElementType elemType = GrLiteralImpl.getLiteralType(this);
        return TypesUtil.getPsiType(this, elemType);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitLiteralExpression(this);
    }

    public Object getValue() {
        return GrLiteralImpl.getLiteralValue(this.getFirstChild());
    }

    public static Object getLiteralValue(PsiElement child) {
        IElementType elemType = child.getNode().getElementType();
        String text = child.getText();
        if (TokenSets.NUMBERS.contains(elemType)) {
            try {
                if (elemType == GroovyTokenTypes.mNUM_INT) {
                    char lastChar = text.charAt(text.length() - 1);
                    if (lastChar == 'i' || lastChar == 'I') {
                        text = text.substring(0, text.length() - 1);
                    }
                    return PsiLiteralUtil.parseInteger((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_LONG) {
                    return PsiLiteralUtil.parseLong((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_FLOAT) {
                    return PsiLiteralUtil.parseFloat((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_DOUBLE) {
                    return PsiLiteralUtil.parseDouble((String)text);
                }
                if (elemType == GroovyTokenTypes.mNUM_BIG_INT) {
                    return new BigInteger(text);
                }
                if (elemType == GroovyTokenTypes.mNUM_BIG_DECIMAL) {
                    return new BigDecimal(text);
                }
            }
            catch (NumberFormatException lastChar) {}
        } else {
            if (elemType == GroovyTokenTypes.kFALSE) {
                return Boolean.FALSE;
            }
            if (elemType == GroovyTokenTypes.kTRUE) {
                return Boolean.TRUE;
            }
            if (elemType == GroovyElementTypes.STRING_SQ || elemType == GroovyElementTypes.STRING_TSQ) {
                StringBuilder chars;
                if (!text.startsWith("'")) {
                    return null;
                }
                boolean result2 = GrStringUtil.parseStringCharacters(text = GrStringUtil.removeQuotes(text), chars = new StringBuilder(text.length()), null);
                return result2 ? chars.toString() : null;
            }
            if (elemType == GroovyElementTypes.STRING_DQ || elemType == GroovyElementTypes.STRING_TDQ) {
                StringBuilder chars;
                if (!text.startsWith("\"")) {
                    return null;
                }
                boolean result3 = GrStringUtil.parseStringCharacters(text = GrStringUtil.removeQuotes(text), chars = new StringBuilder(text.length()), null);
                return result3 ? chars.toString() : null;
            }
            if (elemType == GroovyTokenTypes.mREGEX_LITERAL) {
                StringBuilder chars;
                PsiElement cchild = child.getFirstChild();
                if (cchild == null) {
                    return null;
                }
                PsiElement sibling = cchild.getNextSibling();
                if (sibling == null) {
                    return null;
                }
                text = sibling.getText();
                boolean result4 = GrStringUtil.parseRegexCharacters(text, chars = new StringBuilder(text.length()), null, true);
                return result4 ? chars.toString() : null;
            }
            if (elemType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
                StringBuilder chars;
                PsiElement cchild = child.getFirstChild();
                if (cchild == null) {
                    return null;
                }
                PsiElement sibling = cchild.getNextSibling();
                if (sibling == null) {
                    return null;
                }
                text = sibling.getText();
                boolean result5 = GrStringUtil.parseRegexCharacters(text, chars = new StringBuilder(text.length()), null, false);
                return result5 ? chars.toString() : null;
            }
            if (elemType == GroovyTokenTypes.kNULL) {
                return ObjectUtils.NULL;
            }
        }
        return null;
    }

    public static IElementType getLiteralType(GrLiteral literal) {
        PsiElement firstChild = literal.getFirstChild();
        assert (firstChild != null);
        return firstChild.getNode().getElementType();
    }

    public boolean isStringLiteral() {
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return false;
        }
        IElementType elementType = child.getNode().getElementType();
        return TokenSets.STRING_LITERAL_SET.contains(elementType);
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        if (references.length > 1) {
            return new PsiMultiReference(references, (PsiElement)this);
        }
        return null;
    }

    public boolean isValidHost() {
        Object value = this.getValue();
        return value instanceof String && !((String)value).isEmpty();
    }

    @Override
    public GrLiteralImpl updateText(@NotNull String text) {
        GrExpression newExpr = GroovyPsiElementFactory.getInstance(this.getProject()).createExpressionFromText(text);
        LOG.assertTrue(newExpr instanceof GrLiteral, (Object)text);
        LOG.assertTrue(newExpr.getFirstChild() != null, (Object)text);
        ASTNode valueNode = this.getNode().getFirstChildNode();
        this.getNode().replaceChild(valueNode, newExpr.getFirstChild().getNode());
        return this;
    }

    @NotNull
    public LiteralTextEscaper<GrLiteralContainer> createLiteralTextEscaper() {
        return new GrLiteralEscaper(this);
    }
}

