/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.params;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableBaseImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrParameterStub;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class GrParameterImpl
extends GrVariableBaseImpl<GrParameterStub>
implements GrParameter {
    public GrParameterImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrParameterImpl(GrParameterStub stub) {
        super(stub, GroovyStubElementTypes.PARAMETER);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitParameter(this);
    }

    public String toString() {
        return "Parameter";
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        PsiType declaredType = this.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        if (this.isVarArgs()) {
            PsiClassType type2 = TypesUtil.getJavaLangObject(this);
            return new PsiEllipsisType((PsiType)type2);
        }
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrForInClause) {
            GrExpression iteratedExpression = ((GrForInClause)parent2).getIteratedExpression();
            if (iteratedExpression == null) {
                return null;
            }
            PsiType result2 = ClosureParameterEnhancer.findTypeForIteration(iteratedExpression, (PsiElement)this);
            if (result2 != null) {
                return result2;
            }
        } else {
            if (parent2 instanceof GrTraditionalForClause) {
                return super.getTypeGroovy();
            }
            if (parent2 instanceof GrCatchClause) {
                return TypesUtil.createTypeByFQClassName("java.lang.Exception", this);
            }
        }
        return GrVariableEnhancer.getEnhancedType(this);
    }

    @Override
    public PsiType getDeclaredType() {
        PsiType type2 = super.getDeclaredType();
        if (this.isVarArgs()) {
            if (type2 == null) {
                type2 = TypesUtil.getJavaLangObject(this);
            }
            return new PsiEllipsisType(type2);
        }
        return type2;
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (this.isMainMethodFirstUntypedParameter()) {
            return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement("java.lang.String[]", this).getType();
        }
        return super.getType();
    }

    private boolean isMainMethodFirstUntypedParameter() {
        if (this.getTypeElementGroovy() != null) {
            return false;
        }
        if (!(this.getParent() instanceof GrParameterList)) {
            return false;
        }
        if (this.isOptional()) {
            return false;
        }
        GrParameterList parameterList = (GrParameterList)this.getParent();
        if (!(parameterList.getParent() instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)parameterList.getParent();
        return PsiImplUtil.isMainMethod(method);
    }

    @Override
    public void setType(@Nullable PsiType type2) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getTypeElementGroovy();
        if (type2 == null) {
            if (typeElement != null) {
                typeElement.delete();
            }
            return;
        }
        try {
            newTypeElement = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(type2);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (typeElement == null) {
            GrModifierList modifierList = this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(newTypeElement, modifierList);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(newTypeElement);
        }
        JavaCodeStyleManager.getInstance((Project)this.getProject()).shortenClassReferences((PsiElement)newTypeElement);
    }

    @Override
    public boolean isOptional() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.hasInitializer(stub.getFlags());
        }
        return this.getInitializerGroovy() != null;
    }

    @Override
    @Nullable
    public PsiElement getEllipsisDots() {
        return this.findChildByType(GroovyTokenTypes.mTRIPLE_DOT);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        GrDocCommentOwner owner;
        GrDocComment comment;
        if (!this.isPhysical()) {
            PsiFile file = this.getContainingFile();
            PsiElement context = file.getContext();
            if (context != null) {
                return new LocalSearchScope(context);
            }
            return super.getUseScope();
        }
        PsiElement scope = this.getDeclarationScope();
        if (scope instanceof GrDocCommentOwner && (comment = (owner = (GrDocCommentOwner)scope).getDocComment()) != null) {
            return new LocalSearchScope(new PsiElement[]{scope, comment});
        }
        return new LocalSearchScope(scope);
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getRequiredStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        return Objects.requireNonNull(PsiTreeUtil.getParentOfType((PsiElement)this, GrParametersOwner.class));
    }

    public boolean isVarArgs() {
        GrParameterStub stub = (GrParameterStub)this.getStub();
        if (stub != null) {
            return GrParameterStub.isVarRags(stub.getFlags());
        }
        PsiElement dots = this.getEllipsisDots();
        return dots != null;
    }
}

