/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    public GrEnumTypeDefinitionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, (IStubElementType)GroovyStubElementTypes.ENUM_TYPE_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        return new PsiClassType[]{this.createEnumType()};
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass("java.lang.Enum", this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor);
        }
        return TypesUtil.createTypeByFQClassName("java.lang.Enum", this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            NameHint nameHint2 = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint2 == null ? null : nameHint2.getName(state);
            for (PsiMethod method : this.getDefEnumMethods()) {
                if (name != null && !name.equals(method.getName()) || processor.execute((PsiElement)method, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private PsiMethod[] getDefEnumMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiMethod[] defMethods = new PsiMethod[4];
            PsiManagerEx manager = this.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
            PsiClassType thisType = factory.createType((PsiClass)this);
            defMethods[0] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "values").setMethodReturnType((PsiType)new PsiArrayType((PsiType)thisType)).setContainingClass((PsiClass)this).addModifier("public").addModifier("static");
            defMethods[1] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "next").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public");
            defMethods[2] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "previous").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public");
            defMethods[3] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "valueOf").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addParameter("name", "java.lang.String").addModifier("public").addModifier("static");
            return CachedValueProvider.Result.create((Object)defMethods, (Object[])new Object[]{this});
        });
    }

    @Override
    @NotNull
    public GrEnumConstant[] getEnumConstants() {
        GrEnumDefinitionBody body = this.getBody();
        return body == null ? GrEnumConstant.EMPTY_ARRAY : body.getEnumConstants();
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        return enumDefinitionBody == null ? null : enumDefinitionBody.getEnumConstantList();
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitEnumDefinition(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        GrEnumConstant[] constants;
        if (!(psiElement instanceof GrEnumConstant)) {
            return super.add(psiElement);
        }
        GrEnumDefinitionBody body = this.getBody();
        assert (body != null);
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null && (constants = list.getEnumConstants()).length > 0) {
            list.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
            list.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", null);
            return list.add(psiElement);
        }
        PsiElement brace = body.getLBrace();
        return body.addAfter(psiElement, brace);
    }
}

