/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.code.BodyCodeMembersProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.code.GrCodeMembersProvider;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class GrTypeDefinitionMembersCache<T extends GrTypeDefinition> {
    private final T myDefinition;
    private final GrCodeMembersProvider<? super T> myCodeMembersProvider;
    private final Collection<?> myDependencies = Collections.singletonList(PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);

    public GrTypeDefinitionMembersCache(@NotNull T definition) {
        this((GrTypeDefinition)definition, BodyCodeMembersProvider.INSTANCE);
    }

    public GrTypeDefinitionMembersCache(@NotNull T definition, @NotNull GrCodeMembersProvider<? super T> provider2) {
        this.myDefinition = definition;
        this.myCodeMembersProvider = provider2;
    }

    public GrTypeDefinition[] getCodeInnerClasses() {
        return (GrTypeDefinition[])((GrTypeDefinition[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeInnerClasses(this.myDefinition), this.myDependencies))).clone();
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])((GrMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeMethods(this.myDefinition), this.myDependencies))).clone();
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])((GrMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getCodeConstructors(this.myDefinition), this.myDependencies))).clone();
    }

    public GrField[] getCodeFields() {
        return (GrField[])((GrField[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeFields(this.myDefinition), this.myDependencies))).clone();
    }

    public PsiClass[] getInnerClasses() {
        return (PsiClass[])this.getTransformationResult().getInnerClasses().clone();
    }

    public PsiMethod[] getMethods() {
        return (PsiMethod[])this.getTransformationResult().getMethods().clone();
    }

    public PsiMethod[] getConstructors() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return (PsiMethod[])((PsiMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getConstructors(this.myDefinition), this.myDependencies))).clone();
    }

    public GrField[] getFields() {
        return (GrField[])this.getTransformationResult().getFields().clone();
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        return (PsiClassType[])((PsiClassType[])CachedValuesManager.getCachedValue(this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] extendsTypes = this.getTransformationResult().getExtendsTypes();
            return CachedValueProvider.Result.create((Object)extendsTypes, this.myDependencies);
        } : () -> {
            PsiClassType[] extendsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getExtendsClause());
            return CachedValueProvider.Result.create((Object)extendsTypes, this.myDependencies);
        }))).clone();
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        return (PsiClassType[])((PsiClassType[])CachedValuesManager.getCachedValue(this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] implementsTypes = this.getTransformationResult().getImplementsTypes();
            return CachedValueProvider.Result.create((Object)implementsTypes, this.myDependencies);
        } : () -> {
            PsiClassType[] implementsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getImplementsClause());
            return CachedValueProvider.Result.create((Object)implementsTypes, this.myDependencies);
        }))).clone();
    }

    @NotNull
    private TransformationResult getTransformationResult() {
        return (TransformationResult)CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)TransformationUtilKt.transformDefinition(this.myDefinition), this.myDependencies));
    }
}

