/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrReflectedMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public abstract class GrMethodBaseImpl
extends GrStubElementBase<GrMethodStub>
implements GrMethod,
StubBasedPsiElement<GrMethodStub> {
    private static final Logger LOG = Logger.getInstance(GrMethodBaseImpl.class);
    private static final Function<GrMethodBaseImpl, PsiType> ourTypesCalculator = new NullableFunction<GrMethodBaseImpl, PsiType>(){

        private boolean hasTypeParametersToInfer(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult2 = classType.resolveGenerics();
            PsiClass aClass = resolveResult2.getElement();
            if (aClass == null) {
                return false;
            }
            Iterable iterable = com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass);
            if (!iterable.iterator().hasNext()) {
                return false;
            }
            for (PsiTypeParameter parameter : iterable) {
                PsiType type2 = resolveResult2.getSubstitutor().substitute(parameter);
                if (type2 == null || type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).getBound() == null) continue;
                return false;
            }
            return true;
        }

        public PsiType fun(GrMethodBaseImpl method) {
            PsiType inferred;
            PsiType nominal = method.getNominalType();
            if (!(nominal == null || nominal instanceof PsiClassType && this.hasTypeParametersToInfer((PsiClassType)nominal))) {
                return nominal;
            }
            GrOpenBlock block = method.getBlock();
            if (block != null && (inferred = GroovyPsiManager.inferType(method, new MethodTypeInferencer(block))) != null && (nominal == null || nominal.isAssignableFrom(inferred) && !inferred.equals(PsiType.NULL))) {
                return inferred;
            }
            if (nominal != null) {
                return nominal;
            }
            return TypesUtil.getJavaLangObject(method);
        }
    };

    protected GrMethodBaseImpl(GrMethodStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public GrMethodBaseImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitMethod(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        return this.findNotNullChildByType(TokenSets.PROPERTY_NAMES);
    }

    @Override
    @Nullable
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findChildByClass(GrOpenBlock.class);
    }

    @Override
    public boolean hasBlock() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        return stub != null ? stub.hasBlock() : GrMethod.super.hasBlock();
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        ASTNode newNode = newBlock.getNode().copyElement();
        GrOpenBlock oldBlock = this.getBlock();
        if (oldBlock == null) {
            this.getNode().addChild(newNode);
            return;
        }
        this.getNode().replaceChild(oldBlock.getNode(), newNode);
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    @Nullable
    public GrTypeElement getReturnTypeElementGroovy() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String typeText = stub.getTypeText();
            if (typeText != null) {
                return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this);
            }
            return null;
        }
        return (GrTypeElement)this.findChildByType(TokenSets.TYPE_ELEMENTS);
    }

    @Override
    public PsiType getInferredReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiType)TypeInferenceHelper.inTopContext(() -> GroovyPsiManager.getInstance(this.getProject()).getType(this, ourTypesCalculator));
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null && !list.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (ResolveUtilKt.shouldProcessLocals(processor)) {
            for (GrParameter parameter : this.getParameters()) {
                if (ResolveUtil.processElement(processor, (PsiNamedElement)parameter, state)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiType type2 = this.getNominalType();
        if (type2 != null) {
            return type2;
        }
        return TypesUtil.getJavaLangObject(this);
    }

    @Nullable
    private PsiType getNominalType() {
        if (PsiImplUtil.isMainMethod(this)) {
            return PsiType.VOID;
        }
        GrTypeElement element = this.getReturnTypeElementGroovy();
        if (element != null) {
            return element.getType();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getReturnTypeElementGroovy();
        if (newReturnType == null || newReturnType == PsiType.NULL) {
            if (typeElement != null) {
                typeElement.delete();
            }
            this.insertPlaceHolderToModifierList();
            return null;
        }
        GrTypeElement stub = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(newReturnType);
        if (typeElement == null) {
            GrTypeParameterList typeParameterList = this.getTypeParameterList();
            GroovyPsiElement anchor = typeParameterList != null ? typeParameterList : this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(stub, anchor);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(stub);
        }
        return newTypeElement;
    }

    private void insertPlaceHolderToModifierList() {
        GrModifierList list = this.getModifierList();
        PsiImplUtil.insertPlaceHolderToModifierListAtEndIfNeeded(list);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? JetgroovyIcons.Groovy.AbstractMethod : JetgroovyIcons.Groovy.Method;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon((Icon)methodIcon, (PsiModifierListOwner)this, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    @Nullable
    public PsiTypeElement getReturnTypeElement() {
        return PsiImplUtil.getOrCreateTypeElement(this.getReturnTypeElementGroovy());
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList parameterList = (GrParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.PARAMETER_LIST);
        LOG.assertTrue(parameterList != null);
        return parameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return (PsiReferenceList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyStubElementTypes.THROWS_CLAUSE));
    }

    @Nullable
    public PsiCodeBlock getBody() {
        return PsiImplUtil.getOrCreatePsiCodeBlock(this.getBlock());
    }

    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
    }

    @Nullable
    public PsiMethod findDeepestSuperMethod() {
        PsiMethod[] methods = this.findDeepestSuperMethods();
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        return (GrModifierList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST));
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public String getName() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PsiImplUtil.getName(this);
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement newNameElement;
        PsiElement nameElement = this.getNameIdentifierGroovy();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(nameElement.getProject());
        if (PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(name)) {
            try {
                GrMethod method = factory.createMethod(name, null);
                newNameElement = method.getNameIdentifierGroovy();
            }
            catch (IncorrectOperationException e) {
                newNameElement = factory.createLiteralFromValue(name).getFirstChild();
            }
        } else {
            newNameElement = factory.createLiteralFromValue(name).getFirstChild();
        }
        nameElement.replace(newNameElement);
        return this;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            return list.getTypeParameters();
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    public PsiClass getContainingClass() {
        PsiElement grandParent;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GrTypeDefinitionBody && (grandParent = parent2.getParent()) instanceof PsiClass) {
            return (PsiClass)grandParent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null && !stub.hasComment()) {
            return null;
        }
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        return com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature((PsiMethod)this, false);
        return originalMethod != null ? originalMethod : this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof GroovyFileImpl || parent2 instanceof GrTypeDefinitionBody) {
            super.delete();
            return;
        }
        throw new IncorrectOperationException("Invalid enclosing type definition");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                return Collections.emptyMap();
            }
            HashMap result2 = ContainerUtil.newHashMap();
            for (String parameter : namedParameters) {
                result2.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            return result2;
        }
        GrOpenBlock body = this.getBlock();
        if (body == null) {
            return Collections.emptyMap();
        }
        GrParameter[] parameters = this.getParameters();
        if (parameters.length == 0) {
            return Collections.emptyMap();
        }
        GrParameter firstParameter = parameters[0];
        PsiType type2 = firstParameter.getTypeGroovy();
        GrTypeElement typeElement = firstParameter.getTypeElementGroovy();
        if (type2 != null && typeElement != null && !type2.getPresentableText().endsWith("Map")) {
            return Collections.emptyMap();
        }
        GrNamedArgumentSearchVisitor visitor2 = new GrNamedArgumentSearchVisitor(firstParameter.getNameIdentifierGroovy().getText());
        body.accept(visitor2);
        return visitor2.getResult();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another);
    }

    @Override
    @NotNull
    public GrReflectedMethod[] getReflectedMethods() {
        return GrReflectedMethodImpl.createReflectedMethods(this);
    }
}

