/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.AnnotationArgConverter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightClassReferenceElement;

public class GrLightAnnotation
extends LightElement
implements GrAnnotation {
    private final GrLightAnnotationArgumentList myAnnotationArgList;
    private final String myQualifiedName;
    private final PsiAnnotationOwner myOwner;
    private final PsiElement myContext;
    private final GrLightClassReferenceElement myRef;

    public GrLightAnnotation(@NotNull PsiManager manager, @NotNull Language language, @NotNull String qualifiedName, @NotNull PsiModifierList owner) {
        super(manager, language);
        this.myQualifiedName = qualifiedName;
        this.myOwner = owner;
        this.myContext = owner;
        this.myAnnotationArgList = new GrLightAnnotationArgumentList(manager, language);
        this.myRef = new GrLightClassReferenceElement(qualifiedName, qualifiedName, this);
    }

    public GrLightAnnotation(@NotNull PsiAnnotationOwner owner, @NotNull PsiElement context, @NotNull String qualifiedName, @NotNull Map<String, String> params) {
        super(context.getManager(), context.getLanguage());
        this.myQualifiedName = qualifiedName;
        this.myOwner = owner;
        this.myContext = context;
        this.myAnnotationArgList = new GrLightAnnotationArgumentList(context.getManager(), context.getLanguage());
        this.myRef = new GrLightClassReferenceElement(qualifiedName, qualifiedName, this);
        params.forEach((key, value) -> this.addAttribute((String)key, (String)value));
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public PsiFile getContainingFile() {
        return this.myContext.getContainingFile();
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        return this.myRef;
    }

    @Override
    @NotNull
    public String getShortName() {
        return StringUtil.getShortName((String)this.myQualifiedName);
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        return this.myAnnotationArgList;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitAnnotation(this);
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
    }

    public String toString() {
        return "light groovy annotation";
    }

    public String getText() {
        return "@" + this.myQualifiedName + this.myAnnotationArgList.getText();
    }

    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult2 = this.myRef.advancedResolve();
        PsiElement resolved = resolveResult2.getElement();
        if (resolved instanceof PsiClass) {
            return new LightClassReference(this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult2.getSubstitutor());
        }
        return null;
    }

    public PsiAnnotationMemberValue findAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value) {
        throw new UnsupportedOperationException("light annotation does not support changes");
    }

    public PsiAnnotationOwner getOwner() {
        return this.myOwner;
    }

    public void addAttribute(PsiNameValuePair pair) {
        if (pair instanceof GrAnnotationNameValuePair) {
            this.myAnnotationArgList.addAttribute((GrAnnotationNameValuePair)pair);
        } else {
            GrAnnotationMemberValue newValue = new AnnotationArgConverter().convert(pair.getValue());
            if (newValue == null) {
                return;
            }
            String name = pair.getName();
            this.addAttribute(name, newValue.getText());
        }
    }

    public void addAttribute(@Nullable String name, @NotNull String value) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        String text = name != null ? name + "=" + value : value;
        this.myAnnotationArgList.addAttribute(factory.createAnnotationAttribute(text, this));
    }

    private class GrLightAnnotationArgumentList
    extends LightElement
    implements GrAnnotationArgumentList {
        private List<GrAnnotationNameValuePair> myAttributes;
        private GrAnnotationNameValuePair[] myCachedAttributes;

        public PsiElement getContext() {
            return GrLightAnnotation.this;
        }

        private GrLightAnnotationArgumentList(@NotNull PsiManager manager, Language language) {
            super(manager, language);
            this.myAttributes = null;
            this.myCachedAttributes = GrAnnotationNameValuePair.EMPTY_ARRAY;
        }

        @Override
        @NotNull
        public GrAnnotationNameValuePair[] getAttributes() {
            if (this.myCachedAttributes == null) {
                assert (this.myAttributes != null);
                this.myCachedAttributes = this.myAttributes.toArray(GrAnnotationNameValuePair.EMPTY_ARRAY);
            }
            return this.myCachedAttributes;
        }

        public void addAttribute(@NotNull GrAnnotationNameValuePair attribute) {
            if (this.myAttributes == null) {
                this.myAttributes = ContainerUtilRt.newArrayList();
            }
            this.myAttributes.add(attribute);
            this.myCachedAttributes = null;
        }

        @Override
        public void accept(@NotNull GroovyElementVisitor visitor2) {
            visitor2.visitAnnotationArgumentList(this);
        }

        @Override
        public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
            if (this.myAttributes != null) {
                for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                    attribute.accept(visitor2);
                }
            }
        }

        public String toString() {
            return "light annotation argument list";
        }

        public String getText() {
            if (this.myAttributes == null || this.myAttributes.isEmpty()) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append('(');
            for (GrAnnotationNameValuePair attribute : this.myAttributes) {
                buffer.append(attribute.getText());
                buffer.append(',');
            }
            if (!this.myAttributes.isEmpty()) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append(')');
            return buffer.toString();
        }
    }
}

