/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.EmptyStub;
import com.intellij.psi.stubs.IStubElementType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

public class GrTypeParameterListImpl
extends GrStubElementBase<EmptyStub>
implements GrTypeParameterList,
StubBasedPsiElement<EmptyStub>,
PsiListLikeElement {
    public GrTypeParameterListImpl(EmptyStub stub) {
        super(stub, (IStubElementType)GroovyEmptyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public GrTypeParameterListImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Type parameter list";
    }

    @Override
    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        return (GrTypeParameter[])this.getStubOrPsiChildren(GroovyStubElementTypes.TYPE_PARAMETER, GrTypeParameter.ARRAY_FACTORY);
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        GrTypeParameter[] typeParameters = this.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (!typeParameters[i].equals(typeParameter)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitTypeParameterList(this);
    }

    public PsiElement add(@NotNull PsiElement element) {
        if (!(element instanceof PsiTypeParameter)) {
            return super.add(element);
        }
        return this.addInternal(element.getNode(), element.getNode(), null, true).getPsi();
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        this.appendParenthesesIfNeeded();
        if (first == last && first.getPsi() instanceof PsiTypeParameter) {
            boolean hasParams;
            boolean bl = hasParams = this.getTypeParameters().length > 0;
            ASTNode _anchor = anchor == null ? (before.booleanValue() ? this.getLastChild().getNode() : this.getFirstChild().getNode()) : anchor;
            ASTNode node = super.addInternal(first, last, _anchor, before);
            if (hasParams) {
                this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor != null ? anchor : node);
            }
            return node;
        }
        return super.addInternal(first, last, anchor, before);
    }

    private void appendParenthesesIfNeeded() {
        GrModifierList list;
        PsiElement[] modifiers;
        PsiElement parent2;
        PsiElement last;
        PsiElement first = this.getFirstChild();
        if (first == null) {
            this.getNode().addLeaf(GroovyTokenTypes.mLT, (CharSequence)"<", null);
        }
        if ((last = this.getLastChild()).getNode().getElementType() != GroovyTokenTypes.mGT) {
            this.getNode().addLeaf(GroovyTokenTypes.mGT, (CharSequence)">", null);
        }
        if ((parent2 = this.getParent()) instanceof GrMethod && (modifiers = (list = ((GrMethod)parent2).getModifierList()).getModifiers()).length == 0) {
            list.setModifierProperty("def", true);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (!ResolveUtilKt.shouldProcessTypeParameters(processor)) {
            return true;
        }
        for (GrTypeParameter typeParameter : this.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        return Arrays.asList(this.getTypeParameters());
    }
}

