/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrMethodElementType;

public class GrMethodStub
extends StubBase<GrMethod>
implements NamedStub<GrMethod> {
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 1;
    public static final byte HAS_BLOCK = 2;
    public static final byte HAS_COMMENT = 4;
    private final StringRef myName;
    private final String[] myAnnotations;
    private final String[] myNamedParameters;
    private final String myTypeText;
    private final byte myFlags;

    public GrMethodStub(StubElement parent2, StringRef name, String[] annotations2, @NotNull String[] namedParameters, @NotNull GrMethodElementType elementType, @Nullable String typeText, byte flags) {
        super(parent2, (IStubElementType)elementType);
        this.myName = name;
        this.myAnnotations = annotations2;
        this.myNamedParameters = namedParameters;
        this.myTypeText = typeText;
        this.myFlags = flags;
    }

    @NotNull
    public String getName() {
        return StringRef.toString((StringRef)this.myName);
    }

    public String[] getAnnotations() {
        return this.myAnnotations;
    }

    @NotNull
    public String[] getNamedParameters() {
        return this.myNamedParameters;
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isDeprecatedByDoc() {
        return (this.myFlags & 1) != 0;
    }

    public boolean hasBlock() {
        return (this.myFlags & 2) != 0;
    }

    public boolean hasComment() {
        return (this.myFlags & 4) != 0;
    }

    public static byte buildFlags(GrMethod method) {
        byte f = 0;
        if (PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)method)) {
            f = (byte)(f | 1);
        }
        if (method.hasBlock()) {
            f = (byte)(f | 2);
        }
        if (method.getDocComment() != null) {
            f = (byte)(f | 4);
        }
        return f;
    }

    public byte getFlags() {
        return this.myFlags;
    }
}

