/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrGenericTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrClosureTypeConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (!TypesUtil.isClassType(targetType, "groovy.lang.Closure")) {
            return null;
        }
        if (!TypesUtil.isClassType(actualType, "groovy.lang.Closure")) {
            return null;
        }
        PsiClass lclass = ((PsiClassType)targetType).resolve();
        PsiClass rclass = ((PsiClassType)actualType).resolve();
        if (lclass == null || rclass == null) {
            return null;
        }
        PsiClassType.ClassResolveResult lresult = ((PsiClassType)targetType).resolveGenerics();
        PsiClassType.ClassResolveResult rresult = ((PsiClassType)actualType).resolveGenerics();
        if (GrGenericTypeConverter.typeParametersAgree(lclass, rclass, lresult.getSubstitutor(), rresult.getSubstitutor(), context)) {
            return ConversionResult.OK;
        }
        return null;
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        return position == GrTypeConverter.ApplicableTo.METHOD_PARAMETER;
    }
}

