/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrListToArrayTypeConverter
extends GrTypeConverter {
    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        if (!(targetType instanceof PsiArrayType) || !(actualType instanceof GrTupleType)) {
            return null;
        }
        PsiType lComponentType = ((PsiArrayType)targetType).getComponentType();
        for (PsiType rComponentType : ((GrTupleType)actualType).getComponentTypes()) {
            if (TypesUtil.isAssignableByParameter(lComponentType, rComponentType, context)) continue;
            return null;
        }
        return ConversionResult.OK;
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        return position == GrTypeConverter.ApplicableTo.ASSIGNMENT;
    }
}

