/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class CollectClassMembersUtil {
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS = Key.create((String)"CACHED_CLASS_MEMBERS");
    private static final Key<CachedValue<ClassMembers>> CACHED_MEMBERS_INCLUDING_SYNTHETIC = Key.create((String)"CACHED_MEMBERS_INCLUDING_SYNTHETIC");

    private CollectClassMembersUtil() {
    }

    @NotNull
    public static Map<String, List<CandidateInfo>> getAllMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).methods;
    }

    @NotNull
    private static ClassMembers getCachedMembers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        CachedValue cached = (CachedValue)aClass.getUserData(CollectClassMembersUtil.getMemberCacheKey(includeSynthetic));
        if (cached != null && cached.hasUpToDateValue()) {
            return (ClassMembers)cached.getValue();
        }
        return CollectClassMembersUtil.buildCache(aClass, includeSynthetic && CollectClassMembersUtil.checkClass(aClass));
    }

    private static boolean checkClass(@NotNull PsiClass aClass) {
        HashSet visited = ContainerUtil.newHashSet();
        LinkedList queue = ContainerUtil.newLinkedList((Object[])new PsiClass[]{aClass});
        while (!queue.isEmpty()) {
            PsiClass current = (PsiClass)queue.remove();
            if (current instanceof ClsClassImpl) continue;
            if (visited.add(current)) {
                if (TransformationUtilKt.isUnderTransformation(current)) {
                    return false;
                }
                for (PsiClass superClass : CollectClassMembersUtil.getSupers(current, false)) {
                    queue.offer(superClass);
                }
                continue;
            }
            if (current.isInterface() || "java.lang.Object".equals(current.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).innerClasses;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return CollectClassMembersUtil.getCachedMembers(aClass, includeSynthetic).fields;
    }

    @NotNull
    public static Map<String, CandidateInfo> getAllFields(@NotNull PsiClass aClass) {
        return CollectClassMembersUtil.getAllFields(aClass, true);
    }

    @NotNull
    private static ClassMembers buildCache(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return (ClassMembers)CachedValuesManager.getManager((Project)aClass.getProject()).getCachedValue((UserDataHolder)aClass, CollectClassMembersUtil.getMemberCacheKey(includeSynthetic), () -> {
            ClassMembers result2 = new ClassMembers();
            CollectClassMembersUtil.processClass(aClass, result2.fields, result2.methods, result2.innerClasses, new HashSet(), PsiSubstitutor.EMPTY, includeSynthetic);
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    private static Key<CachedValue<ClassMembers>> getMemberCacheKey(boolean includeSynthetic) {
        return includeSynthetic ? CACHED_MEMBERS_INCLUDING_SYNTHETIC : CACHED_MEMBERS;
    }

    private static void processClass(@NotNull PsiClass aClass, @NotNull Map<String, CandidateInfo> allFields, @NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull Map<String, CandidateInfo> allInnerClasses, @NotNull Set<? super PsiClass> visitedClasses, @NotNull PsiSubstitutor substitutor, boolean includeSynthetic) {
        String name;
        PsiUtilCore.ensureValid((PsiElement)aClass);
        if (!visitedClasses.add((PsiClass)aClass)) {
            return;
        }
        if (visitedClasses.size() == 1 || !GrTraitUtil.isTrait(aClass)) {
            for (PsiField psiField : CollectClassMembersUtil.getFields(aClass, includeSynthetic)) {
                name = psiField.getName();
                if (allFields.containsKey(name)) continue;
                allFields.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
            }
        }
        for (PsiField psiField : CollectClassMembersUtil.getMethods(aClass, includeSynthetic)) {
            CollectClassMembersUtil.addMethod(allMethods, (PsiMethod)psiField, substitutor);
        }
        for (PsiField psiField : CollectClassMembersUtil.getInnerClasses(aClass, includeSynthetic)) {
            name = psiField.getName();
            if (name == null || allInnerClasses.containsKey(name)) continue;
            allInnerClasses.put(name, new CandidateInfo((PsiElement)psiField, substitutor));
        }
        for (PsiField psiField : CollectClassMembersUtil.getSupers(aClass, includeSynthetic)) {
            PsiSubstitutor superSubstitutor = includeSynthetic ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiField, (PsiClass)aClass, (PsiSubstitutor)substitutor) : PsiSubstitutor.EMPTY;
            CollectClassMembersUtil.processClass((PsiClass)psiField, allFields, allMethods, allInnerClasses, visitedClasses, superSubstitutor, includeSynthetic);
        }
    }

    @NotNull
    private static PsiField[] filterProperties(PsiField[] fields) {
        if (fields.length == 0) {
            return PsiField.EMPTY_ARRAY;
        }
        List fieldNamesList = ContainerUtil.mapNotNull((Object[])fields, it -> CollectClassMembersUtil.hasExplicitVisibilityModifiers(it) ? it.getName() : null);
        if (fieldNamesList.isEmpty()) {
            return fields;
        }
        HashSet fieldNames = new HashSet(fieldNamesList);
        return ContainerUtil.filter((Object[])fields, it -> CollectClassMembersUtil.hasExplicitVisibilityModifiers(it) || !fieldNames.remove(it.getName())).toArray(PsiField.EMPTY_ARRAY);
    }

    @NotNull
    public static PsiField[] getFields(@NotNull PsiClass aClass, boolean includeSynthetic) {
        PsiField[] fields = includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getFields() : ((GrTypeDefinition)aClass).getCodeFields();
        return CollectClassMembersUtil.filterProperties(fields);
    }

    @NotNull
    public static PsiMethod[] getMethods(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getMethods() : ((GrTypeDefinition)aClass).getCodeMethods();
    }

    @NotNull
    public static PsiClass[] getInnerClasses(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return includeSynthetic || !(aClass instanceof GrTypeDefinition) ? aClass.getInnerClasses() : ((GrTypeDefinition)aClass).getCodeInnerClasses();
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass aClass, boolean includeSynthetic) {
        return aClass instanceof GrTypeDefinition ? ((GrTypeDefinition)aClass).getSupers(includeSynthetic) : aClass.getSupers();
    }

    private static boolean hasExplicitVisibilityModifiers(@NotNull PsiField field) {
        if (field instanceof GrField) {
            GrModifierList list = (GrModifierList)field.getModifierList();
            return list == null || list.hasExplicitVisibilityModifiers();
        }
        return true;
    }

    private static void addMethod(@NotNull Map<String, List<CandidateInfo>> allMethods, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        String name = method.getName();
        List<CandidateInfo> methods = allMethods.get(name);
        if (methods == null) {
            methods = new ArrayList<CandidateInfo>();
            allMethods.put(name, methods);
        }
        methods.add(new CandidateInfo((PsiElement)method, substitutor));
    }

    private static class ClassMembers {
        private final Map<String, CandidateInfo> fields = ContainerUtil.newLinkedHashMap();
        private final Map<String, List<CandidateInfo>> methods = ContainerUtil.newLinkedHashMap();
        private final Map<String, CandidateInfo> innerClasses = ContainerUtil.newLinkedHashMap();

        private ClassMembers() {
        }
    }
}

