/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiTreeUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.BaseGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.CollapsingKt;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.InnersKt;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StarImport;
import org.jetbrains.plugins.groovy.lang.resolve.imports.StaticImport;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.CollectElementsProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.TypeParameterProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002\u001a\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u0012H\u0002\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u000b*\u00020\u0010H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u000bH\u0002\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019H\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u001c\u0010\u001f\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u001c\u0010 \u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a$\u0010!\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u001a\u0010#\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0010H\u0002\u001a\u0012\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0010H\u0002\u001a\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0019H\u0002\u001a\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0010H\u0002\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+*\u0004\u0018\u00010+H\u0002\u00a8\u0006,"}, d2={"resolveImportReference", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFile;", "import", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/GroovyImport;", "resolveStaticImportReference", "Lorg/jetbrains/plugins/groovy/lang/resolve/imports/StaticImport;", "resolveToTypeParameter", "place", "Lcom/intellij/psi/PsiElement;", "name", "", "canResolveToInnerClassOfCurrentClass", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/types/GrCodeReferenceElement;", "canResolveToPackage", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "canResolveToTypeParameter", "getActualParent", "getCurrentClass", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrTypeDefinition;", "getPackage", "Lcom/intellij/psi/PsiPackage;", "Lcom/intellij/psi/PsiClass;", "processClasses", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "processFileLevelDeclarations", "processInnerClasses", "processQualifier", "qualifier", "processUnqualified", "resolveAsImportReference", "resolveAsPackageReference", "resolveAsPartOfFqn", "reference", "clazz", "resolveAsReference", "skipDummies", "Lcom/intellij/psi/PsiFile;", "intellij.groovy.psi"})
public final class GrCodeReferenceResolverKt {
    private static final Collection<GroovyResolveResult> resolveAsPackageReference(@NotNull GrCodeReferenceElement $receiver) {
        PsiPackage psiPackage = ReferencesKt.resolvePackageFqn($receiver);
        if (psiPackage == null) {
            return CollectionsKt.emptyList();
        }
        PsiPackage aPackage = psiPackage;
        return CollectionsKt.listOf(new ElementResolveResult<PsiElement>((PsiElement)aPackage));
    }

    private static final Collection<GroovyResolveResult> resolveAsImportReference(@NotNull GrCodeReferenceElement $receiver) {
        GrCodeReferenceElement classReference;
        PsiFile psiFile = $receiver.getContainingFile();
        if (!(psiFile instanceof GroovyFile)) {
            psiFile = null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile == null) {
            return CollectionsKt.emptyList();
        }
        GroovyFile file = groovyFile;
        PsiElement $receiver$iv = $receiver;
        boolean $i$f$parentOfType = false;
        GrImportStatement grImportStatement = (GrImportStatement)com.intellij.psi.util.PsiTreeUtilKt.parentOfType((PsiElement)$receiver$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(GrImportStatement.class)});
        if (grImportStatement == null) {
            return CollectionsKt.emptyList();
        }
        GrImportStatement statement = grImportStatement;
        GrCodeReferenceElement grCodeReferenceElement = statement.getImportReference();
        if (grCodeReferenceElement == null) {
            return CollectionsKt.emptyList();
        }
        GrCodeReferenceElement topLevelReference = grCodeReferenceElement;
        GroovyImport groovyImport = statement.getImport();
        if (groovyImport == null) {
            return CollectionsKt.emptyList();
        }
        GroovyImport groovyImport2 = groovyImport;
        if ($receiver == topLevelReference) {
            return groovyImport2 instanceof StaticImport ? GrCodeReferenceResolverKt.resolveStaticImportReference(file, (StaticImport)groovyImport2) : GrCodeReferenceResolverKt.resolveImportReference(file, groovyImport2);
        }
        if ($receiver.getParent() == topLevelReference && groovyImport2 instanceof StaticImport) {
            return GrCodeReferenceResolverKt.resolveImportReference(file, groovyImport2);
        }
        if (groovyImport2 instanceof StarImport) {
            return GrCodeReferenceResolverKt.resolveAsPackageReference($receiver);
        }
        PsiElement psiElement = groovyImport2.resolveImport(file);
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass clazz = (PsiClass)psiElement;
        GrCodeReferenceElement grCodeReferenceElement2 = classReference = groovyImport2 instanceof StaticImport ? (GrCodeReferenceElement)topLevelReference.getQualifier() : topLevelReference;
        if (clazz == null || classReference == null) {
            return GrCodeReferenceResolverKt.resolveAsPackageReference($receiver);
        }
        return GrCodeReferenceResolverKt.resolveAsPartOfFqn($receiver, classReference, clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<GroovyResolveResult> resolveStaticImportReference(GroovyFile file, StaticImport staticImport) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        CollectElementsProcessor processor = new CollectElementsProcessor();
        staticImport.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), file, file);
        Iterable iterable = $receiver$iv = (Iterable)CollapsingKt.collapseAccessors(CollapsingKt.collapseReflectedMethods((Collection<? extends PsiElement>)processor.getResults()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ElementResolveResult<void> elementResolveResult = new ElementResolveResult<void>(p1);
            collection.add(elementResolveResult);
        }
        return (List)destination$iv$iv;
    }

    private static final Collection<GroovyResolveResult> resolveImportReference(GroovyFile file, GroovyImport groovyImport) {
        PsiElement psiElement = groovyImport.resolveImport(file);
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement resolved = psiElement;
        return CollectionsKt.listOf(new ElementResolveResult<PsiElement>(resolved));
    }

    private static final Collection<GroovyResolveResult> resolveAsReference(@NotNull GrCodeReferenceElement $receiver) {
        Collection<GroovyResolveResult> packages;
        Collection<GroovyResolveResult> collection;
        PsiClass clazz;
        Pair typeParameters;
        Pair pair;
        String string = $receiver.getReferenceName();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String name = string;
        if (GrCodeReferenceResolverKt.canResolveToTypeParameter($receiver) && !(pair = (typeParameters = GrCodeReferenceResolverKt.resolveToTypeParameter($receiver, name))).isEmpty()) {
            return typeParameters;
        }
        PsiElement $receiver$iv = $receiver;
        boolean $i$f$skipSameTypeParents = false;
        Object lastParent$iv = $receiver$iv;
        PsiElement parent$iv = $receiver$iv.getParent();
        while (parent$iv instanceof GrCodeReferenceElement) {
            lastParent$iv = parent$iv;
            parent$iv = parent$iv.getParent();
        }
        pair = new Pair((Object)parent$iv, lastParent$iv);
        GrCodeReferenceElement outerMostReference = (GrCodeReferenceElement)pair.component2();
        if (outerMostReference != $receiver) {
            PsiClass fqnReferencedClass = ReferencesKt.resolveClassFqn(outerMostReference);
            if (fqnReferencedClass != null) {
                return GrCodeReferenceResolverKt.resolveAsPartOfFqn($receiver, outerMostReference, fqnReferencedClass);
            }
        } else if ($receiver.isQualified() && (clazz = ReferencesKt.resolveClassFqn($receiver)) != null) {
            return CollectionsKt.listOf((Object)ClassProcessor.Companion.createResult(clazz, $receiver, ResolveState.initial(), PsiImplUtilKt.getExplicitTypeArguments($receiver)));
        }
        ClassProcessor processor = new ClassProcessor(name, $receiver, PsiImplUtilKt.getExplicitTypeArguments($receiver), ResolveUtilKt.isAnnotationReference($receiver));
        ResolveState state = ResolveState.initial();
        GrCodeReferenceResolverKt.processClasses($receiver, processor, state);
        List classes2 = processor.getResults();
        lastParent$iv = classes2;
        if (!lastParent$iv.isEmpty()) {
            return classes2;
        }
        if (GrCodeReferenceResolverKt.canResolveToPackage($receiver) && !(collection = (packages = GrCodeReferenceResolverKt.resolveAsPackageReference($receiver))).isEmpty()) {
            return packages;
        }
        return CollectionsKt.emptyList();
    }

    private static final boolean canResolveToTypeParameter(@NotNull GrReferenceElement<?> $receiver) {
        if ($receiver.isQualified()) {
            return false;
        }
        PsiElement parent2 = $receiver.getParent();
        PsiElement psiElement = parent2;
        return !(psiElement instanceof GrReferenceElement) && !(psiElement instanceof GrExtendsClause) && !(psiElement instanceof GrImplementsClause) && !(psiElement instanceof GrAnnotation) && !(psiElement instanceof GrImportStatement) && !(psiElement instanceof GrNewExpression) && !(psiElement instanceof GrAnonymousClassDefinition) && !(psiElement instanceof GrCodeReferenceElement);
    }

    private static final Collection<GroovyResolveResult> resolveToTypeParameter(PsiElement place, String name) {
        TypeParameterProcessor processor = new TypeParameterProcessor(name);
        PsiTreeUtilKt.treeWalkUp$default(place, processor, null, null, 6, null);
        return processor.getResults();
    }

    private static final boolean canResolveToPackage(@NotNull GrReferenceElement<?> $receiver) {
        return $receiver.getParent() instanceof GrReferenceElement;
    }

    private static final Collection<GroovyResolveResult> resolveAsPartOfFqn(@NotNull GrCodeReferenceElement $receiver, GrCodeReferenceElement reference, PsiClass clazz) {
        GrCodeReferenceElement currentReference = reference;
        PsiNamedElement currentElement = (PsiNamedElement)clazz;
        while (currentReference != $receiver) {
            PsiNamedElement e;
            PsiNamedElement psiNamedElement;
            if ((GrCodeReferenceElement)currentReference.getQualifier() == null) {
                return CollectionsKt.emptyList();
            }
            PsiNamedElement psiNamedElement2 = currentElement;
            if (psiNamedElement2 instanceof PsiClass) {
                PsiClass psiClass = ((PsiClass)currentElement).getContainingClass();
                psiNamedElement = psiClass != null ? (PsiNamedElement)psiClass : (PsiNamedElement)GrCodeReferenceResolverKt.getPackage((PsiClass)currentElement);
            } else {
                psiNamedElement = e = psiNamedElement2 instanceof PsiPackage ? (PsiNamedElement)((PsiPackage)currentElement).getParentPackage() : null;
            }
            if (e != null) continue;
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf(new BaseGroovyResolveResult((PsiElement)currentElement, $receiver, null, null, null, 28, null));
    }

    private static final PsiPackage getPackage(@NotNull PsiClass $receiver) {
        Object object;
        PsiFile file = $receiver.getContainingFile();
        PsiFile psiFile = file;
        if (!(psiFile instanceof PsiClassOwner)) {
            psiFile = null;
        }
        if ((object = (PsiClassOwner)psiFile) == null || (object = object.getPackageName()) == null) {
            return null;
        }
        Object name = object;
        return JavaPsiFacade.getInstance((Project)((PsiClassOwner)file).getProject()).findPackage((String)name);
    }

    public static final boolean processClasses(@NotNull GrCodeReferenceElement $receiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        GrCodeReferenceElement qualifier = (GrCodeReferenceElement)$receiver.getQualifier();
        if (qualifier == null) {
            return GrCodeReferenceResolverKt.processUnqualified($receiver, processor, state);
        }
        return GrCodeReferenceResolverKt.processQualifier($receiver, qualifier, processor, state);
    }

    public static final boolean processUnqualified(@NotNull PsiElement $receiver, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        return GrCodeReferenceResolverKt.processInnerClasses($receiver, processor, state) && GrCodeReferenceResolverKt.processFileLevelDeclarations($receiver, processor, state);
    }

    private static final boolean processInnerClasses(@NotNull PsiElement $receiver, PsiScopeProcessor processor, ResolveState state) {
        GrTypeDefinition grTypeDefinition = GrCodeReferenceResolverKt.getCurrentClass($receiver);
        if (grTypeDefinition == null) {
            return true;
        }
        GrTypeDefinition currentClass = grTypeDefinition;
        if (!($receiver instanceof GrCodeReferenceElement && !GrCodeReferenceResolverKt.canResolveToInnerClassOfCurrentClass((GrCodeReferenceElement)$receiver) || InnersKt.processInnerInHierarchy(currentClass, processor, state, $receiver))) {
            return false;
        }
        return InnersKt.processInnersInOuters(currentClass, processor, state, $receiver);
    }

    private static final boolean processFileLevelDeclarations(@NotNull PsiElement $receiver, PsiScopeProcessor processor, ResolveState state) {
        PsiFile psiFile = GrCodeReferenceResolverKt.skipDummies($receiver.getContainingFile());
        if (psiFile == null) {
            return true;
        }
        PsiFile file = psiFile;
        return PsiTreeUtilKt.treeWalkUp((PsiElement)file, processor, state, $receiver);
    }

    private static final boolean processQualifier(@NotNull GrCodeReferenceElement $receiver, GrCodeReferenceElement qualifier, PsiScopeProcessor processor, ResolveState state) {
        for (GroovyResolveResult result2 : qualifier.multiResolve(false)) {
            PsiClass clazz;
            PsiElement psiElement = result2.getElement();
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            if ((PsiClass)psiElement == null) {
                continue;
            }
            if (clazz.processDeclarations(processor, state.put(PsiSubstitutor.KEY, (Object)result2.getSubstitutor()), null, (PsiElement)$receiver)) continue;
            return false;
        }
        return true;
    }

    private static final boolean canResolveToInnerClassOfCurrentClass(@NotNull GrCodeReferenceElement $receiver) {
        PsiElement $receiver$iv = $receiver;
        boolean $i$f$skipSameTypeParents = false;
        PsiElement lastParent$iv = $receiver$iv;
        PsiElement parent$iv = $receiver$iv.getParent();
        while (parent$iv instanceof GrCodeReferenceElement) {
            lastParent$iv = parent$iv;
            parent$iv = parent$iv.getParent();
        }
        Pair pair = new Pair((Object)parent$iv, (Object)lastParent$iv);
        GrCodeReferenceElement outerMostReference = (GrCodeReferenceElement)pair.component2();
        PsiElement parent2 = GrCodeReferenceResolverKt.getActualParent(outerMostReference);
        return !(parent2 instanceof GrExtendsClause) && !(parent2 instanceof GrImplementsClause) && (!(parent2 instanceof GrAnnotation) || Intrinsics.areEqual((Object)((GrAnnotation)parent2).getClassReference(), (Object)$receiver) ^ true);
    }

    private static final PsiElement getActualParent(@NotNull GrCodeReferenceElement $receiver) {
        PsiElement psiElement = $receiver.getContainingFile().getContext();
        if (psiElement == null) {
            psiElement = $receiver.getParent();
        }
        return psiElement;
    }

    private static final GrTypeDefinition getCurrentClass(@NotNull PsiElement $receiver) {
        for (PsiElement context : PsiTreeUtilKt.contexts($receiver)) {
            if (!(context instanceof GrTypeDefinition) || context instanceof GrTypeParameter || context instanceof GrAnonymousClassDefinition && $receiver == ((GrAnonymousClassDefinition)context).getBaseClassReferenceGroovy()) continue;
            return (GrTypeDefinition)context;
        }
        return null;
    }

    private static final PsiFile skipDummies(@Nullable PsiFile $receiver) {
        PsiFile file = $receiver;
        while (file != null && !file.isPhysical()) {
            PsiElement context = file.getContext();
            if (context == null) {
                return file;
            }
            file = context.getContainingFile();
        }
        return file;
    }

    public static final /* synthetic */ Collection access$resolveAsPackageReference(GrCodeReferenceElement $receiver) {
        return GrCodeReferenceResolverKt.resolveAsPackageReference($receiver);
    }

    public static final /* synthetic */ Collection access$resolveAsImportReference(GrCodeReferenceElement $receiver) {
        return GrCodeReferenceResolverKt.resolveAsImportReference($receiver);
    }

    public static final /* synthetic */ Collection access$resolveAsReference(GrCodeReferenceElement $receiver) {
        return GrCodeReferenceResolverKt.resolveAsReference($receiver);
    }
}

