/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.JustTypeArgument;

public abstract class GrMethodComparator {
    public static final ExtensionPointName<GrMethodComparator> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.methodComparator");

    public abstract Boolean dominated(@NotNull GroovyMethodResult var1, @NotNull GroovyMethodResult var2, @NotNull Context var3);

    @NotNull
    public static Boolean checkDominated(@NotNull GroovyMethodResult result1, @NotNull GroovyMethodResult result2, @NotNull Context context) {
        for (GrMethodComparator comparator : (GrMethodComparator[])EP_NAME.getExtensions()) {
            Boolean result3 = comparator.dominated(result1, result2, context);
            if (result3 == null) continue;
            return result3;
        }
        return true;
    }

    public static int compareMethods(@NotNull GroovyMethodResult result1, @NotNull GroovyMethodResult result2, @NotNull Context context) {
        boolean secondIsPreferable;
        PsiMethod method1 = result1.getElement();
        PsiMethod method2 = result2.getElement();
        if (!method1.getName().equals(method2.getName())) {
            return 0;
        }
        boolean firstIsPreferable = GrMethodComparator.checkDominated(result2, result1, context);
        if (firstIsPreferable == (secondIsPreferable = GrMethodComparator.checkDominated(result1, result2, context).booleanValue())) {
            if (method1 instanceof GrGdkMethod && !(method2 instanceof GrGdkMethod)) {
                return 1;
            }
            if (!(method1 instanceof GrGdkMethod) && method2 instanceof GrGdkMethod) {
                return -1;
            }
            if (secondIsPreferable) {
                return 1;
            }
            return 0;
        }
        if (firstIsPreferable) {
            return -1;
        }
        return 1;
    }

    public static interface Context {
        @Nullable
        default public List<Argument> getArguments() {
            Object[] types = this.getArgumentTypes();
            return types == null ? null : ContainerUtil.map((Object[])types, JustTypeArgument::new);
        }

        public PsiType[] getArgumentTypes();

        @NotNull
        public PsiElement getPlace();

        public boolean isConstructor();
    }
}

