/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.noncode;

import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class MixinMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (MixinMemberContributor.isInAnnotation(place)) {
            return;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierType);
        if (aClass == null) {
            return;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        ArrayList mixins = new ArrayList();
        for (PsiAnnotation annotation : MixinMemberContributor.getAllMixins(modifierList)) {
            PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
            if (value instanceof GrAnnotationArrayInitializer) {
                GrAnnotationMemberValue[] initializers;
                for (GrAnnotationMemberValue initializer : initializers = ((GrAnnotationArrayInitializer)value).getInitializers()) {
                    MixinMemberContributor.addMixin(initializer, mixins);
                }
                continue;
            }
            if (!(value instanceof GrExpression)) continue;
            MixinMemberContributor.addMixin((GrExpression)value, mixins);
        }
        MixinProcessor delegate = new MixinProcessor(processor, qualifierType, place);
        for (PsiClass mixin : mixins) {
            if (mixin.processDeclarations((PsiScopeProcessor)delegate, state, null, place)) continue;
            return;
        }
    }

    public static String getOriginInfoForCategory(PsiMethod element) {
        PsiClass aClass = element.getContainingClass();
        if (aClass != null && aClass.getName() != null) {
            return "mixed in from " + aClass.getName();
        }
        return "mixed in";
    }

    public static String getOriginInfoForMixin(@NotNull PsiType subjectType) {
        return "mixed in " + subjectType.getPresentableText();
    }

    private static List<PsiAnnotation> getAllMixins(PsiModifierList modifierList) {
        ArrayList<PsiAnnotation> result2 = new ArrayList<PsiAnnotation>();
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            if (!"groovy.lang.Mixin".equals(annotation.getQualifiedName())) continue;
            result2.add(annotation);
        }
        return result2;
    }

    private static boolean isInAnnotation(PsiElement place) {
        return place.getParent() instanceof GrAnnotation || place.getParent() instanceof GrAnnotationArrayInitializer;
    }

    private static void addMixin(GrAnnotationMemberValue value, List<? super PsiClass> mixins) {
        PsiElement resolved;
        if (value instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)value).resolve()) instanceof PsiClass) {
            mixins.add((PsiClass)((PsiClass)resolved));
        }
    }

    public static class MixinProcessor
    extends DelegatingScopeProcessor {
        private final PsiType myType;
        private final PsiElement myPlace;

        public MixinProcessor(PsiScopeProcessor delegate, @NotNull PsiType qualifierType, @Nullable PsiElement place) {
            super(delegate);
            this.myType = qualifierType;
            this.myPlace = place;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element instanceof PsiMethod && GdkMethodUtil.isCategoryMethod((PsiMethod)element, this.myType, this.myPlace, (PsiSubstitutor)state.get(PsiSubstitutor.KEY))) {
                PsiMethod method = (PsiMethod)element;
                String originInfo = MixinMemberContributor.getOriginInfoForCategory(method);
                return super.execute((PsiElement)GrGdkMethodImpl.createGdkMethod(method, false, originInfo), state);
            }
            if (element instanceof PsiMethod) {
                return super.execute((PsiElement)new MixinedMethod((PsiMethod)element, MixinMemberContributor.getOriginInfoForMixin(this.myType)), state);
            }
            return super.execute(element, state);
        }
    }

    private static class MixinedMethod
    extends LightMethod
    implements OriginInfoAwareElement,
    PsiMirrorElement {
        private final String myOriginInfo;
        private final PsiMethod myPrototype;

        MixinedMethod(@NotNull PsiMethod method, String originInfo) {
            super(method.getManager(), method, (PsiClass)ObjectUtils.assertNotNull((Object)method.getContainingClass()));
            this.myOriginInfo = originInfo;
            this.myPrototype = method;
        }

        @Nullable
        public String getOriginInfo() {
            return this.myOriginInfo;
        }

        @NotNull
        public PsiElement getPrototype() {
            return this.myPrototype;
        }
    }
}

