/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.KindsResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MultiProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u00042\u00020\u00052\u00020\u0006B#\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020 J\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u001fR\u001f\u0010\u000f\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/AccessorAwareResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/KindsResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/GrResolverProcessor;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lcom/intellij/psi/scope/ElementClassHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DynamicMembersHint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/MultiProcessor;", "name", "", "place", "Lcom/intellij/psi/PsiElement;", "kinds", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolveKind;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Ljava/util/Set;)V", "accessorCandidates", "", "Lkotlin/jvm/JvmWildcard;", "getAccessorCandidates", "()Ljava/util/List;", "accessorProcessors", "", "getAccessorProcessors", "()Ljava/util/Collection;", "results", "getResults", "getCandidates", "kind", "getProcessors", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "shouldProcess", "", "Lcom/intellij/psi/scope/ElementClassHint$DeclarationKind;", "shouldProcessMethods", "shouldProcessProperties", "intellij.groovy.psi"})
public abstract class AccessorAwareResolverProcessor
extends KindsResolverProcessor
implements GrResolverProcessor<GroovyResolveResult>,
ElementClassHint,
DynamicMembersHint,
MultiProcessor {
    @Override
    public final boolean shouldProcessProperties() {
        return true;
    }

    @Override
    public final boolean shouldProcessMethods() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        GroovyResolveKind it;
        if (kind == ElementClassHint.DeclarationKind.METHOD) return false;
        Iterable $receiver$iv = this.getKinds();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (GroovyResolveKind)((Object)element$iv);
            boolean bl = false;
        } while (!it.declarationKinds.contains(kind));
        return true;
    }

    @NotNull
    public final Collection<PsiScopeProcessor> getProcessors() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this), (Iterable)this.getAccessorProcessors());
    }

    @NotNull
    protected abstract Collection<GrResolverProcessor<?>> getAccessorProcessors();

    /*
     * WARNING - void declaration
     */
    private final List<? extends GroovyResolveResult> getAccessorCandidates() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getAccessorProcessors();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            GrResolverProcessor it = (GrResolverProcessor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getResults();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    private final List<GroovyResolveResult> getCandidates(GroovyResolveKind kind) {
        Object object;
        block3: {
            block2: {
                GroovyResolveResult groovyResolveResult;
                object = this.getCandidate(kind);
                if (object == null) break block2;
                GroovyResolveResult p1 = groovyResolveResult = object;
                boolean bl = false;
                object = CollectionsKt.listOf((Object)p1);
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        Object result2 = object;
        return kind == GroovyResolveKind.PROPERTY ? CollectionsKt.plus((Collection)((Collection)result2), (Iterable)this.getAccessorCandidates()) : result2;
    }

    @Override
    @NotNull
    public final List<GroovyResolveResult> getResults() {
        List<GroovyResolveResult> fields;
        List<GroovyResolveResult> variables = this.getCandidates(GroovyResolveKind.VARIABLE);
        Collection collection = variables;
        if (!collection.isEmpty()) {
            return variables;
        }
        List<GroovyResolveResult> properties = ResolveUtilKt.singleOrValid(this.getCandidates(GroovyResolveKind.PROPERTY));
        if (!properties.isEmpty()) {
            GroovyResolveResult property = (GroovyResolveResult)CollectionsKt.singleOrNull(properties);
            if (property != null) {
                if (property.isStaticsOK()) {
                    return properties;
                }
            } else {
                return ContainerUtil.newSmartList((Object)properties.get(0));
            }
        }
        if (!(fields = this.getCandidates(GroovyResolveKind.FIELD)).isEmpty()) {
            return fields;
        }
        Collection collection2 = properties;
        if (!collection2.isEmpty()) {
            return properties;
        }
        List<GroovyResolveResult> bindings = this.getCandidates(GroovyResolveKind.BINDING);
        Collection collection3 = bindings;
        if (!collection3.isEmpty()) {
            return bindings;
        }
        return CollectionsKt.plus((Collection)this.getAllCandidates(), (Object[])ResolveUtil.filterSameSignatureCandidates((Collection<? extends GroovyResolveResult>)this.getAccessorCandidates()));
    }

    public AccessorAwareResolverProcessor(@NotNull String name, @NotNull PsiElement place, @NotNull Set<? extends GroovyResolveKind> kinds) {
        super(name, place, kinds);
        this.hint(ElementClassHint.KEY, this);
        this.hint(DynamicMembersHint.KEY, this);
    }
}

