/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class MethodResolverProcessor
extends ResolverProcessor<GroovyMethodResult>
implements GrMethodComparator.Context {
    @Nullable
    private final PsiType[] myArgumentTypes;
    private final boolean myAllVariants;
    private Set<GroovyMethodResult> myInapplicableCandidates = null;
    private final boolean myIsConstructor;
    private boolean myStopExecuting = false;
    private final SubstitutorComputer mySubstitutorComputer;

    public MethodResolverProcessor(@Nullable String name, @NotNull PsiElement place, boolean isConstructor, @Nullable PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments) {
        this(name, place, isConstructor, thisType, argumentTypes, typeArguments, false);
    }

    public MethodResolverProcessor(@Nullable String name, @NotNull PsiElement place, boolean isConstructor, @Nullable PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments, boolean allVariants) {
        super(name, ClassHint.RESOLVE_KINDS_METHOD_PROPERTY, place);
        this.myIsConstructor = isConstructor;
        this.mySubstitutorComputer = new SubstitutorComputer(thisType, argumentTypes, typeArguments, this.myPlace, this.myPlace.getParent());
        PsiType[] psiTypeArray = this.myArgumentTypes = argumentTypes == null ? null : Arrays.copyOf(argumentTypes, argumentTypes.length);
        if (this.myArgumentTypes != null) {
            for (int i = 0; i < this.myArgumentTypes.length; ++i) {
                this.myArgumentTypes[i] = TypeConversionUtil.erasure((PsiType)this.myArgumentTypes[i]);
            }
        }
        this.myAllVariants = allVariants;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (this.myStopExecuting) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor() != this.myIsConstructor) {
                return true;
            }
            PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            PsiSubstitutor partialSubstitutor = MethodResolverProcessor.getSubstitutor(state);
            NotNullComputable substitutorComputer = () -> this.mySubstitutorComputer.obtainSubstitutor(partialSubstitutor, method, resolveContext);
            boolean isAccessible = this.isAccessible((PsiNamedElement)method);
            boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
            boolean isApplicable = PsiUtil.isApplicable(this.myArgumentTypes, method, partialSubstitutor, this.myPlace, true);
            boolean isValidResult = isStaticsOK && isAccessible && isApplicable;
            GroovyMethodResultImpl candidate = new GroovyMethodResultImpl(method, resolveContext, spreadState, partialSubstitutor, (NotNullComputable<? extends PsiSubstitutor>)substitutorComputer, isAccessible, isStaticsOK, isValidResult);
            if (!this.myAllVariants && isValidResult) {
                this.addCandidate(candidate);
            } else {
                this.addInapplicableCandidate(candidate);
            }
        }
        return true;
    }

    protected boolean addInapplicableCandidate(@NotNull GroovyMethodResult candidate) {
        if (this.myInapplicableCandidates == null) {
            this.myInapplicableCandidates = ContainerUtil.newLinkedHashSet();
        }
        return this.myInapplicableCandidates.add(candidate);
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        return substitutor;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (!this.myAllVariants && this.hasApplicableCandidates()) {
            return this.filterCandidates();
        }
        if (this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty()) {
            Set<GroovyMethodResult> resultSet = this.myAllVariants ? this.myInapplicableCandidates : this.filterCorrectParameterCount(this.myInapplicableCandidates);
            return ResolveUtil.filterSameSignatureCandidates(resultSet);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private Set<GroovyMethodResult> filterCorrectParameterCount(Set<GroovyMethodResult> candidates) {
        if (this.myArgumentTypes == null) {
            return candidates;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (GroovyMethodResult candidate : candidates) {
            if (candidate.getElement().getParameterList().getParametersCount() != this.myArgumentTypes.length) continue;
            result2.add(candidate);
        }
        if (!result2.isEmpty()) {
            return result2;
        }
        return candidates;
    }

    private GroovyResolveResult[] filterCandidates() {
        List<GroovyResolveResult> array = this.getCandidatesInternal();
        if (array.size() == 1) {
            return array.toArray(GroovyResolveResult.EMPTY_ARRAY);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        Iterator itr = array.iterator();
        result2.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyMethodResult resolveResult2 = (GroovyMethodResult)itr.next();
            Iterator iterator2 = result2.iterator();
            while (iterator2.hasNext()) {
                GroovyMethodResult otherResolveResult = (GroovyMethodResult)iterator2.next();
                int res = GrMethodComparator.compareMethods(resolveResult2, otherResolveResult, this);
                if (res > 0) continue block0;
                if (res >= 0) continue;
                iterator2.remove();
            }
            result2.add(resolveResult2);
        }
        return result2.toArray(GroovyResolveResult.EMPTY_ARRAY);
    }

    @Override
    public boolean hasCandidates() {
        return this.hasApplicableCandidates() || this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty();
    }

    public boolean hasApplicableCandidates() {
        return super.hasCandidates();
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.hasApplicableCandidates()) {
            this.myStopExecuting = true;
        }
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        return this.myPlace;
    }

    @Override
    public boolean isConstructor() {
        return this.myIsConstructor;
    }
}

