/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessorImpl;

public class PropertyResolverProcessor
extends ResolverProcessorImpl
implements DynamicMembersHint {
    public PropertyResolverProcessor(String name, PsiElement place) {
        super(name, ClassHint.RESOLVE_KINDS_PROPERTY, place, PsiType.EMPTY_ARRAY);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        return super.execute(element, state) || element instanceof PsiField;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        List<GroovyResolveResult> candidates = this.getCandidatesInternal();
        int size = candidates.size();
        if (size == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult last = (GroovyResolveResult)candidates.get(size - 1);
        if (last.getElement() instanceof GrBindingVariable && size > 1) {
            last = (GroovyResolveResult)candidates.get(size - 2);
        }
        if (PropertyResolverProcessor.isCorrectLocalVarOrParam(last)) {
            return new GroovyResolveResult[]{last};
        }
        for (GroovyResolveResult candidate : candidates) {
            if (!candidate.isStaticsOK()) continue;
            return new GroovyResolveResult[]{candidate};
        }
        return candidates.toArray(GroovyResolveResult.EMPTY_ARRAY);
    }

    private static boolean isCorrectLocalVarOrParam(GroovyResolveResult last) {
        return !(last.getElement() instanceof PsiField) && last.isAccessible() && last.isStaticsOK() && last.getCurrentFileResolveContext() == null;
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == DynamicMembersHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcessProperties() {
        return true;
    }
}

