/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.scope.ElementClassHint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;

public abstract class ResolverProcessor<T extends GroovyResolveResult>
extends GrScopeProcessorWithHints {
    protected final PsiElement myPlace;
    private List<T> myCandidates;

    protected ResolverProcessor(@Nullable String name, @NotNull EnumSet<ElementClassHint.DeclarationKind> resolveTargets, @NotNull PsiElement place) {
        super(name, resolveTargets);
        this.myPlace = place;
    }

    protected final void addCandidate(@NotNull T candidate) {
        PsiElement element = candidate.getElement();
        assert (element == null || element.isValid()) : ResolverProcessor.getElementInfo(element);
        if (this.myCandidates == null) {
            this.myCandidates = new ArrayList<T>();
        }
        this.myCandidates.add(candidate);
    }

    @NotNull
    private static String getElementInfo(@NotNull PsiElement element) {
        PsiElement context;
        String text = element instanceof LightElement ? ((context = element.getContext()) instanceof LightElement ? context.toString() : (context != null ? context.getText() : null)) : element.getText();
        return "invalid resolve candidate: " + element.getClass() + ", text: " + text;
    }

    @NotNull
    protected List<T> getCandidatesInternal() {
        return this.myCandidates == null ? Collections.emptyList() : this.myCandidates;
    }

    protected boolean isAccessible(@NotNull PsiNamedElement namedElement) {
        if (namedElement instanceof GrField) {
            GrField field = (GrField)namedElement;
            if (PsiUtil.isAccessible(this.myPlace, field)) {
                return true;
            }
            for (GrAccessorMethod method : field.getGetters()) {
                if (!PsiUtil.isAccessible(this.myPlace, (PsiMember)method)) continue;
                return true;
            }
            GrAccessorMethod setter = field.getSetter();
            return setter != null && PsiUtil.isAccessible(this.myPlace, (PsiMember)setter);
        }
        return !(namedElement instanceof PsiMember) || PsiUtil.isAccessible(this.myPlace, (PsiMember)namedElement);
    }

    protected boolean isStaticsOK(@NotNull PsiNamedElement element, @Nullable PsiElement resolveContext, boolean filterStaticAfterInstanceQualifier) {
        if (resolveContext instanceof GrImportStatement) {
            return true;
        }
        if (element instanceof PsiModifierListOwner) {
            return GrStaticChecker.isStaticsOK((PsiModifierListOwner)element, this.myPlace, resolveContext, filterStaticAfterInstanceQualifier);
        }
        return true;
    }

    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (this.myCandidates == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return this.myCandidates.toArray(GroovyResolveResult.EMPTY_ARRAY);
    }

    public boolean hasCandidates() {
        return this.myCandidates != null;
    }

    public String toString() {
        return "NameHint: '" + this.myName + "', " + this.myResolveTargetKinds + ", Candidates: " + (this.myCandidates == null ? 0 : this.myCandidates.size());
    }
}

