/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

public class SubstitutorComputer {
    private static final Logger LOG = Logger.getInstance(SubstitutorComputer.class);
    protected final PsiElement myPlace;
    private final Lazy<PsiType> myThisType;
    @Nullable
    private final PsiType[] myArgumentTypes;
    @Nullable
    private final PsiType[] myTypeArguments;
    private final PsiElement myPlaceToInferContext;
    private final NotNullLazyValue<Collection<PsiElement>> myExitPoints;
    private final PsiResolveHelper myHelper;

    public SubstitutorComputer(@Nullable PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments, PsiElement place, PsiElement placeToInferContext) {
        this((Lazy<PsiType>)LazyKt.lazyOf((Object)thisType), argumentTypes, typeArguments, place, placeToInferContext);
    }

    public SubstitutorComputer(@NotNull Lazy<PsiType> thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments, PsiElement place, PsiElement placeToInferContext) {
        this.myThisType = thisType;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myPlace = place;
        this.myPlaceToInferContext = placeToInferContext;
        this.myExitPoints = VolatileNotNullLazyValue.createValue(() -> {
            if (SubstitutorComputer.canBeExitPoint(place)) {
                GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
                return ContainerUtil.newHashSet(ControlFlowUtils.collectReturns(flowOwner));
            }
            return ContainerUtil.emptyList();
        });
        this.myHelper = JavaPsiFacade.getInstance((Project)this.myPlace.getProject()).getResolveHelper();
    }

    @Nullable
    protected PsiType inferContextType() {
        PsiElement parent2 = this.myPlaceToInferContext.getParent();
        if (parent2 instanceof GrReturnStatement || ((Collection)this.myExitPoints.getValue()).contains(this.myPlaceToInferContext)) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent2, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
            if (method != null) {
                return method.getReturnType();
            }
        } else {
            if (parent2 instanceof GrAssignmentExpression && this.myPlaceToInferContext.equals(((GrAssignmentExpression)parent2).getRValue())) {
                PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent2).getLValue(), false);
                if (lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty)) {
                    return ((GrExpression)lValue).getNominalType();
                }
                return null;
            }
            if (parent2 instanceof GrVariable) {
                return ((GrVariable)parent2).getDeclaredType();
            }
        }
        return null;
    }

    private static boolean canBeExitPoint(PsiElement place) {
        while (place != null) {
            if (place instanceof GrMethod || place instanceof GrClosableBlock || place instanceof GrClassInitializer) {
                return true;
            }
            if (place instanceof GrThrowStatement || place instanceof GrTypeDefinitionBody || place instanceof GroovyFile) {
                return false;
            }
            place = place.getParent();
        }
        return false;
    }

    public PsiSubstitutor obtainSubstitutor(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethod method, @Nullable PsiElement resolveContext) {
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (this.myTypeArguments != null && this.myTypeArguments.length == typeParameters.length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiType typeArgument = this.myTypeArguments[i];
                substitutor = substitutor.put(typeParameter, typeArgument);
            }
            return substitutor;
        }
        if (this.myArgumentTypes != null && method.hasTypeParameters()) {
            PsiType[] argTypes = this.myArgumentTypes;
            if (method instanceof GrGdkMethod) {
                PsiType[] newArgTypes = PsiType.createArray((int)(argTypes.length + 1));
                newArgTypes[0] = GdkMethodUtil.isInWithContext(resolveContext) ? ((GrExpression)resolveContext).getType() : (PsiType)this.myThisType.getValue();
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                argTypes = newArgTypes;
                method = ((GrGdkMethod)method).getStaticMethod();
                LOG.assertTrue(method.isValid());
            }
            return this.inferMethodTypeParameters(method, substitutor, typeParameters, argTypes);
        }
        return substitutor;
    }

    private PsiSubstitutor inferMethodTypeParameters(@NotNull PsiMethod method, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] argTypes) {
        if (typeParameters.length == 0 || this.myArgumentTypes == null) {
            return partialSubstitutor;
        }
        GrSignature erasedSignature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor, true);
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor);
        GrClosureParameter[] params = signature.getParameters();
        GrClosureSignatureUtil.ArgInfo<PsiType>[] argInfos = GrClosureSignatureUtil.mapArgTypesToParameters(erasedSignature, argTypes, this.myPlace, true);
        if (argInfos == null || params.length > argInfos.length) {
            return partialSubstitutor;
        }
        Deque<InferenceStep> inferenceQueue = this.buildInferenceQueue(method, typeParameters, params, argInfos);
        PsiSubstitutor substitutor = partialSubstitutor;
        while (!inferenceQueue.isEmpty()) {
            substitutor = inferenceQueue.pollFirst().doInfer(substitutor);
        }
        for (PsiTypeParameter typeParameter : typeParameters) {
            if (substitutor.getSubstitutionMap().containsKey(typeParameter) || (substitutor = this.inferFromContext(typeParameter, PsiUtil.getSmartReturnType(method), substitutor)).getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, null);
        }
        return partialSubstitutor.putAll(substitutor);
    }

    @NotNull
    private Deque<InferenceStep> buildInferenceQueue(@NotNull PsiMethod method, @NotNull PsiTypeParameter[] typeParameters, GrClosureParameter[] params, GrClosureSignatureUtil.ArgInfo<PsiType>[] argInfos) {
        ArrayDeque<InferenceStep> inferenceQueue = new ArrayDeque<InferenceStep>();
        ArrayList<PsiType> parameterTypes = new ArrayList<PsiType>();
        ArrayList<Object> argumentTypes = new ArrayList<Object>();
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            PsiType paramType = params[paramIndex].getType();
            GrClosureSignatureUtil.ArgInfo<PsiType> argInfo = argInfos[paramIndex];
            if (argInfo != null) {
                if (argInfo.isMultiArg && paramType instanceof PsiArrayType) {
                    paramType = ((PsiArrayType)paramType).getComponentType();
                }
                for (PsiType type2 : argInfo.args) {
                    PsiType argType = type2;
                    if (InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.Closure")) {
                        inferenceQueue.add(this.handleClosure(paramType, argType, typeParameters));
                        continue;
                    }
                    if (argType instanceof GrTupleType) {
                        PsiType rawWildcardType = TypesUtil.rawWildcard(argType, (PsiElement)method);
                        PsiType psiType = argType = rawWildcardType != null ? rawWildcardType : argType;
                    }
                    if (argType != null) {
                        argType = com.intellij.psi.util.PsiUtil.captureToplevelWildcards((PsiType)argType, (PsiElement)method);
                    }
                    parameterTypes.add(paramType);
                    argumentTypes.add(argType);
                }
                continue;
            }
            parameterTypes.add(paramType);
            argumentTypes.add(PsiType.NULL);
        }
        PsiType[] parameterArray = parameterTypes.toArray(PsiType.EMPTY_ARRAY);
        PsiType[] argumentArray = argumentTypes.toArray(PsiType.EMPTY_ARRAY);
        inferenceQueue.addFirst(this.buildStep(parameterArray, argumentArray, typeParameters));
        return inferenceQueue;
    }

    InferenceStep buildStep(PsiType[] parameterTypes, PsiType[] argumentTypes, PsiTypeParameter[] typeParameters) {
        return ps -> this.myHelper.inferTypeArguments(SubstitutorComputer.collectTypeParams(typeParameters, parameterTypes), parameterTypes, argumentTypes, ps, LanguageLevel.JDK_1_8);
    }

    private InferenceStep handleClosure(PsiType targetType, PsiType argType, @NotNull PsiTypeParameter[] typeParameters) {
        if (targetType instanceof PsiClassType && TypesUtil.isClassType(targetType, "groovy.lang.Closure")) {
            PsiType[] parameters = ((PsiClassType)targetType).getParameters();
            if (parameters.length != 1) {
                return InferenceStep.EMPTY;
            }
            return this.buildReturnTypeClosureStep(argType, parameters[0], typeParameters);
        }
        if (SamConversionKt.isSamConversionAllowed(this.myPlace)) {
            return this.handleConversionOfSAMType(targetType, argType, typeParameters);
        }
        return InferenceStep.EMPTY;
    }

    @NotNull
    private InferenceStep handleConversionOfSAMType(@Nullable PsiType targetType, @NotNull PsiType closure, PsiTypeParameter[] typeParameters) {
        if (!(closure instanceof PsiClassType)) {
            return InferenceStep.EMPTY;
        }
        if (!(targetType instanceof PsiClassType)) {
            return InferenceStep.EMPTY;
        }
        PsiClassType.ClassResolveResult resolveResult2 = ((PsiClassType)targetType).resolveGenerics();
        PsiClass samClass = resolveResult2.getElement();
        if (samClass == null) {
            return InferenceStep.EMPTY;
        }
        PsiMethod sam2 = SamConversionKt.findSingleAbstractMethod(samClass);
        if (sam2 == null) {
            return InferenceStep.EMPTY;
        }
        PsiType samReturnType = resolveResult2.getSubstitutor().substitute(sam2.getReturnType());
        if (samReturnType == null) {
            return InferenceStep.EMPTY;
        }
        return this.buildReturnTypeClosureStep(closure, samReturnType, typeParameters);
    }

    private InferenceStep buildReturnTypeClosureStep(@NotNull PsiType closure, @Nullable PsiType returnType2, PsiTypeParameter[] typeParameters) {
        PsiType[] parameters = ((PsiClassType)closure).getParameters();
        if (parameters.length != 1) {
            return InferenceStep.EMPTY;
        }
        PsiType[] rightTypes = closure instanceof GrClosureType ? ((GrClosureType)closure).inferParameters() : parameters;
        return this.buildStep(new PsiType[]{returnType2}, rightTypes, typeParameters);
    }

    private static PsiTypeParameter[] collectTypeParams(PsiTypeParameter[] parameters, PsiType[] types) {
        HashSet<PsiTypeParameter> visited = new HashSet<PsiTypeParameter>();
        SubstitutorComputer.collectTypeParams(parameters, visited, types);
        return visited.toArray(PsiTypeParameter.EMPTY_ARRAY);
    }

    private static void collectTypeParams(PsiTypeParameter[] parameters, Set<PsiTypeParameter> visited, PsiType ... type2) {
        PsiTypeParameter[] typeParameters;
        for (PsiTypeParameter parameter : typeParameters = PsiTypesUtil.filterUnusedTypeParameters((PsiTypeParameter[])parameters, (PsiType[])type2)) {
            if (!visited.add(parameter)) continue;
            SubstitutorComputer.collectTypeParams(parameters, visited, (PsiType[])parameter.getExtendsListTypes());
        }
    }

    private PsiSubstitutor inferFromContext(@NotNull PsiTypeParameter typeParameter, @Nullable PsiType lType, @NotNull PsiSubstitutor substitutor) {
        if (this.myPlace == null) {
            return substitutor;
        }
        PsiType inferred = this.myHelper.getSubstitutionForTypeParameter(typeParameter, lType, this.inferContextType(), false, LanguageLevel.JDK_1_8);
        if (inferred != PsiType.NULL) {
            return substitutor.put(typeParameter, inferred);
        }
        return substitutor;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    private static interface InferenceStep {
        public static final InferenceStep EMPTY = ps -> ps;

        public PsiSubstitutor doInfer(@NotNull PsiSubstitutor var1);
    }
}

