/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    public static GroovyShortNamesCache getGroovyShortNamesCache(Project project) {
        return (GroovyShortNamesCache)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.findInstance((Iterable)PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)project), GroovyShortNamesCache.class)));
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        SmartList allClasses = new SmartList();
        this.processClassesWithName(name, (Processor<? super PsiClass>)Processors.cancelableCollectProcessor((Collection)allClasses), scope, null);
        if (allClasses.isEmpty()) {
            return PsiClass.EMPTY_ARRAY;
        }
        return allClasses.toArray(PsiClass.EMPTY_ARRAY);
    }

    public List<PsiClass> getScriptClassesByFQName(String name, GlobalSearchScope scope, boolean srcOnly) {
        Object actualScope = srcOnly ? new GrSourceFilterScope(scope) : scope;
        Collection files = StubIndex.getElements(GrFullScriptNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)actualScope, GroovyFile.class);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (GroovyFile file : files) {
            PsiClass scriptClass;
            if (!file.isScript() || (scriptClass = file.getScriptClass()) == null || !name.equals(scriptClass.getQualifiedName())) continue;
            result2.add(scriptClass);
        }
        return result2;
    }

    @NotNull
    public List<PsiClass> getClassesByFQName(String name, GlobalSearchScope scope, boolean inSource) {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiElement psiClass : StubIndex.getElements(GrFullClassNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)(inSource ? new GrSourceFilterScope(scope) : scope), PsiClass.class)) {
            if (!name.equals(((PsiClass)psiClass).getQualifiedName())) continue;
            result2.add((PsiClass)psiClass);
        }
        result2.addAll(this.getScriptClassesByFQName(name, scope, inSource));
        return result2;
    }

    @NotNull
    public String[] getAllClassNames() {
        return ArrayUtil.toStringArray((Collection)StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        Collection methods = StubIndex.getElements(GrMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrMethod.class);
        Collection annMethods = StubIndex.getElements(GrAnnotationMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrAnnotationMethod.class);
        if (methods.isEmpty() && annMethods.isEmpty()) {
            return PsiMethod.EMPTY_ARRAY;
        }
        return (PsiMethod[])ArrayUtil.mergeCollections((Collection)annMethods, (Collection)methods, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        GrSourceFilterScope filterScope = new GrSourceFilterScope(scope);
        return StubIndex.getInstance().processElements(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrMethod.class, processor) && StubIndex.getInstance().processElements(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrAnnotationMethod.class, processor);
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        return this.getMethodsByName(name, scope);
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        return this.getFieldsByName(name, scope);
    }

    @NotNull
    public String[] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        return ArrayUtil.toStringArray((Collection)keys);
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        Collection fields = StubIndex.getElements(GrFieldNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrField.class);
        if (fields.isEmpty()) {
            return PsiField.EMPTY_ARRAY;
        }
        return fields.toArray(PsiField.EMPTY_ARRAY);
    }

    @NotNull
    public String[] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        return ArrayUtil.toStringArray((Collection)fields);
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter, GrField.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return this.processClasses(name, processor, scope, filter) && this.processScriptClasses(name, processor, scope, filter);
    }

    private boolean processClasses(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter, PsiClass.class, processor);
    }

    private boolean processScriptClasses(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        for (GroovyFile file : StubIndex.getElements(GrScriptClassNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), (IdFilter)filter, GroovyFile.class)) {
            PsiClass aClass = file.getScriptClass();
            if (aClass == null || processor.process((Object)aClass)) continue;
            return true;
        }
        return true;
    }
}

