/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ConvertToJavaProcessor;

public class ConvertToJavaHandler
implements RefactoringActionHandler {
    private static final String REFACTORING_NAME = GroovyRefactoringBundle.message("convert.to.java.refactoring.name", new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        ConvertToJavaHandler.invokeInner(project, new PsiElement[]{file}, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor = null;
        if (dataContext != null) {
            editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        }
        ConvertToJavaHandler.invokeInner(project, elements, editor);
    }

    private static void invokeInner(Project project, PsiElement[] elements, Editor editor) {
        HashSet files = ContainerUtil.newHashSet();
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFile)) {
                element = element.getContainingFile();
            }
            if (element instanceof GroovyFile) {
                files.add((GroovyFile)element);
                continue;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GroovyRefactoringBundle.message("convert.to.java.can.work.only.with.groovy", new Object[0]), (String)REFACTORING_NAME, null);
            return;
        }
        new ConvertToJavaProcessor(project, files.toArray(GroovyFile.EMPTY_ARRAY)).run();
    }
}

