/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import gnu.trove.TIntArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeProvider {
    private final Map<GrMethod, PsiType[]> inferredTypes = new HashMap<GrMethod, PsiType[]>();

    @NotNull
    public PsiType getReturnType(@NotNull PsiMethod method) {
        GrTypeElement typeElement;
        if (method instanceof GrMethod && (typeElement = ((GrMethod)method).getReturnTypeElementGroovy()) != null) {
            return typeElement.getType();
        }
        PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
        if (smartReturnType != null && !PsiType.NULL.equals((Object)smartReturnType)) {
            return smartReturnType;
        }
        if (PsiType.NULL.equals((Object)smartReturnType) && PsiUtil.isVoidMethod(method)) {
            return PsiType.VOID;
        }
        return TypesUtil.getJavaLangObject((PsiElement)method);
    }

    @NotNull
    public PsiType getVarType(@NotNull PsiVariable variable) {
        if (variable instanceof PsiParameter) {
            return this.getParameterType((PsiParameter)variable);
        }
        return TypeProvider.getVariableTypeInner(variable);
    }

    @NotNull
    private static PsiType getVariableTypeInner(@NotNull PsiVariable variable) {
        PsiType type2 = null;
        if (variable instanceof GrVariable && (type2 = ((GrVariable)variable).getDeclaredType()) == null) {
            type2 = ((GrVariable)variable).getTypeGroovy();
        }
        if (type2 == null) {
            type2 = variable.getType();
        }
        return type2;
    }

    @NotNull
    public PsiType getParameterType(@NotNull PsiParameter parameter) {
        if (!(parameter instanceof GrParameter)) {
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof GrAccessorMethod) {
                return this.getVarType(((GrAccessorMethod)scope).getProperty());
            }
            return parameter.getType();
        }
        PsiElement parent2 = parameter.getParent();
        if (!(parent2 instanceof GrParameterList)) {
            return TypeProvider.getVariableTypeInner((PsiVariable)parameter);
        }
        PsiElement pparent = parent2.getParent();
        if (!(pparent instanceof GrMethod)) {
            return parameter.getType();
        }
        PsiType[] types = this.inferMethodParameters((GrMethod)pparent);
        return types[((GrParameterList)parent2).getParameterNumber((GrParameter)parameter)];
    }

    @NotNull
    private PsiType[] inferMethodParameters(@NotNull GrMethod method) {
        PsiType[] psiTypes = this.inferredTypes.get(method);
        if (psiTypes != null) {
            return psiTypes;
        }
        GrParameter[] parameters = method.getParameters();
        TIntArrayList paramInds = new TIntArrayList(parameters.length);
        PsiType[] types = PsiType.createArray((int)parameters.length);
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2].getTypeElementGroovy() == null) {
                paramInds.add(i2);
                continue;
            }
            types[i2] = parameters[i2].getType();
        }
        if (!paramInds.isEmpty()) {
            GrSignature signature = GrClosureSignatureUtil.createSignature(method, PsiSubstitutor.EMPTY);
            MethodReferencesSearch.search((PsiMethod)method, (boolean)true).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                PsiManager manager = element.getManager();
                GlobalSearchScope resolveScope = element.getResolveScope();
                if (element instanceof GrReferenceExpression) {
                    GrCall call = (GrCall)element.getParent();
                    GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
                    if (argInfos == null) {
                        return true;
                    }
                    paramInds.forEach(i -> {
                        PsiType type2 = GrClosureSignatureUtil.getTypeByArg(argInfos[i], manager, resolveScope);
                        types[i] = TypesUtil.getLeastUpperBoundNullable(type2, types[i], manager);
                        return true;
                    });
                }
                return true;
            });
        }
        paramInds.forEach(i -> {
            if (types[i] == null || types[i] == PsiType.NULL) {
                types[i] = parameters[i].getType();
            }
            return true;
        });
        this.inferredTypes.put(method, types);
        return types;
    }

    @NotNull
    public PsiType getReturnType(GrClosableBlock closure) {
        PsiType returnType2 = closure.getReturnType();
        if (PsiType.NULL.equals((Object)returnType2) && PsiUtil.isBlockReturnVoid(closure)) {
            return PsiType.VOID;
        }
        if (returnType2 == null) {
            return TypesUtil.getJavaLangObject(closure);
        }
        return TypesUtil.boxPrimitiveType(returnType2, closure.getManager(), closure.getResolveScope());
    }
}

