/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.inline.GrVariableInliner;
import org.jetbrains.plugins.groovy.refactoring.inline.InlineLocalVarSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GroovyInlineLocalProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(GroovyInlineLocalProcessor.class);
    private final InlineLocalVarSettings mySettings;
    private final GrVariable myLocal;

    public GroovyInlineLocalProcessor(Project project, InlineLocalVarSettings settings, GrVariable local) {
        super(project);
        this.mySettings = settings;
        this.myLocal = local;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        return new BaseUsageViewDescriptor(new PsiElement[]{this.myLocal});
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usages;
        MultiMap conflicts = new MultiMap();
        for (UsageInfo usage : usages = (UsageInfo[])refUsages.get()) {
            this.collectConflicts(usage.getReference(), (MultiMap<PsiElement, String>)conflicts);
        }
        return this.showConflicts(conflicts, usages);
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ClosureUsage)) continue;
            return true;
        }
        return false;
    }

    private void collectConflicts(PsiReference reference, MultiMap<PsiElement, String> conflicts) {
        GrExpression expr = (GrExpression)reference.getElement();
        if (PsiUtil.isAccessedForWriting(expr)) {
            conflicts.putValue((Object)expr, (Object)GroovyRefactoringBundle.message("variable.is.accessed.for.writing", this.myLocal.getName()));
        }
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        Instruction[] controlFlow = this.mySettings.getFlow();
        List<BitSet> writes = ControlFlowUtils.inferWriteAccessMap(controlFlow, this.myLocal);
        ArrayList<UsageInfo> toInline = new ArrayList<UsageInfo>();
        GroovyInlineLocalProcessor.collectRefs(this.myLocal, controlFlow, writes, this.mySettings.getWriteInstructionNumber(), toInline);
        return toInline.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void collectRefs(final GrVariable variable, Instruction[] flow, List<BitSet> writes, int writeInstructionNumber, final ArrayList<UsageInfo> toInline) {
        for (Instruction instruction : flow) {
            BitSet prev;
            PsiElement element = instruction.getElement();
            if (instruction instanceof ReadWriteVariableInstruction) {
                GrReferenceExpression ref;
                if (((ReadWriteVariableInstruction)instruction).isWrite() || element instanceof GrVariable && element != variable || !(element instanceof GrReferenceExpression) || (ref = (GrReferenceExpression)element).isQualified() || ref.resolve() != variable) continue;
                BitSet prev2 = writes.get(instruction.num());
                if (writeInstructionNumber >= 0 && prev2.cardinality() == 1 && prev2.get(writeInstructionNumber)) {
                    toInline.add(new UsageInfo((PsiQualifiedReferenceElement)ref));
                    continue;
                }
                if (writeInstructionNumber != -1 || prev2.cardinality() != 0) continue;
                toInline.add(new ClosureUsage((PsiReference)ref));
                continue;
            }
            if (element instanceof GrClosableBlock) {
                prev = writes.get(instruction.num());
                if ((writeInstructionNumber < 0 || prev.cardinality() != 1 || !prev.get(writeInstructionNumber)) && (writeInstructionNumber != -1 || prev.cardinality() != 0)) continue;
                Instruction[] closureFlow = ((GrClosableBlock)element).getControlFlow();
                GroovyInlineLocalProcessor.collectRefs(variable, closureFlow, ControlFlowUtils.inferWriteAccessMap(closureFlow, variable), -1, toInline);
                continue;
            }
            if (!(element instanceof GrAnonymousClassDefinition)) continue;
            prev = writes.get(instruction.num());
            if ((writeInstructionNumber < 0 || prev.cardinality() != 1 || !prev.get(writeInstructionNumber)) && (writeInstructionNumber != -1 || prev.cardinality() != 0)) continue;
            ((GrAnonymousClassDefinition)element).acceptChildren(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitField(@NotNull GrField field) {
                    GrExpression initializer = field.getInitializerGroovy();
                    if (initializer != null) {
                        Instruction[] flow = new ControlFlowBuilder(field.getProject()).buildControlFlow(initializer);
                        GroovyInlineLocalProcessor.collectRefs(variable, flow, ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                    }
                }

                @Override
                public void visitMethod(@NotNull GrMethod method) {
                    GrOpenBlock block = method.getBlock();
                    if (block != null) {
                        Instruction[] flow = block.getControlFlow();
                        GroovyInlineLocalProcessor.collectRefs(variable, flow, ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                    }
                }

                @Override
                public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                    GrOpenBlock block = initializer.getBlock();
                    Instruction[] flow = block.getControlFlow();
                    GroovyInlineLocalProcessor.collectRefs(variable, flow, ControlFlowUtils.inferWriteAccessMap(flow, variable), -1, toInline);
                }
            });
        }
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        Collection all;
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        GrExpression initializer = this.mySettings.getInitializer();
        GrExpression initializerToUse = GrIntroduceHandlerBase.insertExplicitCastIfNeeded(this.myLocal, this.mySettings.getInitializer());
        for (UsageInfo usage : usages) {
            GrVariableInliner.inlineReference(usage, this.myLocal, initializerToUse);
        }
        PsiElement initializerParent = initializer.getParent();
        if (initializerParent instanceof GrAssignmentExpression) {
            initializerParent.delete();
            return;
        }
        if (initializerParent instanceof GrVariable && !(all = ReferencesSearch.search((PsiElement)this.myLocal).findAll()).isEmpty()) {
            initializer.delete();
            return;
        }
        PsiElement owner = this.myLocal.getParent().getParent();
        if (owner instanceof GrVariableDeclarationOwner) {
            ((GrVariableDeclarationOwner)owner).removeVariable(this.myLocal);
        } else {
            this.myLocal.delete();
        }
    }

    @NotNull
    protected String getCommandName() {
        return RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{this.myLocal.getName()});
    }

    private static class ClosureUsage
    extends UsageInfo {
        private ClosureUsage(@NotNull PsiReference reference) {
            super(reference);
        }
    }
}

