/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class InlineMethodConflictSolver {
    private InlineMethodConflictSolver() {
    }

    @NotNull
    public static String suggestNewName(@NotNull String startName, @Nullable GrMethod method, @NotNull PsiElement call, String ... otherNames) {
        String newName;
        PsiElement parent2;
        int i = 1;
        for (parent2 = call.getParent(); !(parent2 instanceof GrVariableDeclarationOwner) && parent2 != null; parent2 = parent2.getParent()) {
        }
        if (parent2 == null || InlineMethodConflictSolver.isValidName(startName, parent2, call) && InlineMethodConflictSolver.isValid(startName, otherNames)) {
            return startName;
        }
        do {
            newName = startName + i;
            ++i;
        } while (method != null && !InlineMethodConflictSolver.isValidNameInMethod(newName, method) || !InlineMethodConflictSolver.isValidName(newName, parent2, call) || !InlineMethodConflictSolver.isValid(newName, otherNames));
        return newName;
    }

    static boolean isValid(@Nullable String name, String ... otherNames) {
        for (String otherName : otherNames) {
            if (!otherName.equals(name)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidNameInMethod(@NotNull String name, @NotNull GrMethod method) {
        for (GrParameter parameter : method.getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block != null) {
            return InlineMethodConflictSolver.isValidNameDown(name, block, null);
        }
        return true;
    }

    public static boolean isValidName(@NotNull String name, @NotNull PsiElement scopeElement, PsiElement call) {
        if (InlineMethodConflictSolver.isValidNameDown(name, scopeElement, call)) {
            if (!(scopeElement instanceof GroovyFileBase)) {
                return InlineMethodConflictSolver.isValidNameUp(name, scopeElement, call);
            }
            return true;
        }
        return false;
    }

    private static boolean isValidNameDown(@NotNull String name, @NotNull PsiElement startElement, @Nullable PsiElement call) {
        PsiElement child = startElement.getFirstChild();
        while (child != null) {
            GrReferenceExpression expr;
            GrExpression lValue;
            if (child instanceof GrTypeDefinition || child instanceof GrMethod || call != null && GroovyRefactoringUtil.isAppropriateContainerForIntroduceVariable(child) && child.getTextRange().getEndOffset() < call.getTextRange().getStartOffset()) {
                child = child.getNextSibling();
                continue;
            }
            if (child instanceof GrAssignmentExpression && (lValue = ((GrAssignmentExpression)child).getLValue()) instanceof GrReferenceExpression && (expr = (GrReferenceExpression)lValue).getQualifierExpression() == null && name.equals(expr.getReferenceName())) {
                return false;
            }
            if (child instanceof GrVariable && name.equals(((GrVariable)child).getName())) {
                return false;
            }
            boolean inner = InlineMethodConflictSolver.isValidNameDown(name, child, call);
            if (!inner) {
                return false;
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private static boolean isValidNameUp(@NotNull String name, @NotNull PsiElement startElement, @Nullable PsiElement call) {
        if (startElement instanceof PsiFile) {
            return true;
        }
        for (PsiElement prevSibling = startElement.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (InlineMethodConflictSolver.isValidNameDown(name, prevSibling, call)) continue;
            return false;
        }
        PsiElement parent2 = startElement.getParent();
        return parent2 == null || parent2 instanceof PsiDirectory || InlineMethodConflictSolver.isValidNameUp(name, parent2, call);
    }
}

