/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.constant;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrAbstractInplaceIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceFieldHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrInplaceConstantIntroducer;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.constant.GrIntroduceConstantSettings;

public class GrIntroduceConstantHandler
extends GrIntroduceFieldHandlerBase<GrIntroduceConstantSettings> {
    public static final String REFACTORING_NAME = "Introduce Constant";

    @Override
    @NotNull
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    @NotNull
    protected String getHelpID() {
        return "refactoring.introduceConstant";
    }

    @Override
    protected void checkExpression(@NotNull GrExpression selectedExpr) {
        GrVariable variable = GrIntroduceHandlerBase.resolveLocalVar(selectedExpr);
        if (variable != null) {
            this.checkVariable(variable);
        } else {
            selectedExpr.accept(new ConstantChecker(selectedExpr, selectedExpr));
        }
    }

    @Override
    protected void checkVariable(@NotNull GrVariable variable) throws GrRefactoringError {
        GrExpression initializer = variable.getInitializerGroovy();
        if (initializer == null) {
            throw new GrRefactoringError(RefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{variable.getName()}));
        }
        this.checkExpression(initializer);
    }

    @Override
    protected void checkStringLiteral(@NotNull StringPartInfo info) throws GrRefactoringError {
    }

    @Override
    protected void checkOccurrences(@NotNull PsiElement[] occurrences) {
        if (GrIntroduceConstantHandler.hasLhs(occurrences)) {
            throw new GrRefactoringError(GroovyRefactoringBundle.message("selected.variable.is.used.for.write", new Object[0]));
        }
    }

    @Nullable
    public static PsiClass findContainingClass(GrIntroduceContext context) {
        return (PsiClass)context.getScope();
    }

    @Override
    @NotNull
    protected GrIntroduceDialog<GrIntroduceConstantSettings> getDialog(@NotNull GrIntroduceContext context) {
        return new GrIntroduceConstantDialog(context, GrIntroduceConstantHandler.findContainingClass(context));
    }

    public GrField runRefactoring(@NotNull GrIntroduceContext context, @NotNull GrIntroduceConstantSettings settings) {
        return new GrIntroduceConstantProcessor(context, settings).run();
    }

    @Override
    protected GrAbstractInplaceIntroducer<GrIntroduceConstantSettings> getIntroducer(@NotNull GrIntroduceContext context, @NotNull OccurrencesChooser.ReplaceChoice choice) {
        Ref contextRef = Ref.create((Object)context);
        if (context.getStringPart() != null) {
            this.extractStringPart((Ref<GrIntroduceContext>)contextRef);
        }
        return new GrInplaceConstantIntroducer((GrIntroduceContext)contextRef.get(), choice);
    }

    @Override
    @NotNull
    protected Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull GrIntroduceContext context) {
        LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        GrVariable localVar = GrIntroduceConstantHandler.resolveLocalVar(context);
        if (localVar != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(context.getOccurrences()));
            return map2;
        }
        if (context.getExpression() != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getExpression()));
        } else if (context.getStringPart() != null) {
            map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(context.getStringPart()));
        }
        PsiElement[] occurrences = context.getOccurrences();
        if (occurrences.length > 1) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
        }
        return map2;
    }

    private static class ConstantChecker
    extends GroovyRecursiveElementVisitor {
        private final PsiElement scope;
        private final GrExpression expr;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
            GrExpression qualifier;
            PsiElement resolved = referenceExpression.resolve();
            if (resolved instanceof PsiVariable) {
                if (ConstantChecker.isStaticFinalField((PsiVariable)resolved)) return;
                if (!(this.expr instanceof GrClosableBlock)) throw new GrRefactoringError(RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
                if (PsiTreeUtil.isContextAncestor((PsiElement)this.scope, (PsiElement)resolved, (boolean)true)) return;
                throw new GrRefactoringError(GroovyRefactoringBundle.message("closure.uses.external.variables", new Object[0]));
            }
            if (!(resolved instanceof PsiMethod) || ((PsiMethod)resolved).getContainingClass() == null || (qualifier = referenceExpression.getQualifierExpression()) != null && (!(qualifier instanceof GrReferenceExpression) || !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) || ((PsiMethod)resolved).hasModifierProperty("static")) return;
            throw new GrRefactoringError(RefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer"));
        }

        private static boolean isStaticFinalField(PsiVariable var) {
            return var instanceof PsiField && var.hasModifierProperty("final") && var.hasModifierProperty("static");
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            if (closure == this.expr) {
                super.visitClosure(closure);
            } else {
                closure.accept(new ConstantChecker(closure, this.scope));
            }
        }

        private ConstantChecker(GrExpression expr, PsiElement expressionScope) {
            this.scope = expressionScope;
            this.expr = expr;
        }
    }
}

