/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;

public abstract class GrIntroduceLocalVariableProcessor {
    private static final Logger LOG = Logger.getInstance(GrIntroduceLocalVariableProcessor.class);
    private final GrIntroduceContext myContext;
    private final GroovyIntroduceVariableSettings mySettings;
    private final boolean myProcessUsages;
    private final PsiElement[] myOccurrences;
    private final GrExpression myExpression;

    public GrIntroduceLocalVariableProcessor(@NotNull GrIntroduceContext context, @NotNull GroovyIntroduceVariableSettings settings, @NotNull PsiElement[] occurrences, @NotNull GrExpression expression, boolean processUsages) {
        PsiElement[] psiElementArray;
        this.myContext = context;
        this.mySettings = settings;
        this.myProcessUsages = processUsages;
        if (settings.replaceAllOccurrences()) {
            psiElementArray = occurrences;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = expression;
        }
        this.myOccurrences = psiElementArray;
        this.myExpression = expression;
    }

    @NotNull
    public GrVariable processExpression(@NotNull GrVariableDeclaration declaration) {
        GrIntroduceLocalVariableProcessor.resolveLocalConflicts(this.myContext.getScope(), this.mySettings.getName());
        this.preprocessOccurrences();
        int expressionIndex = ArrayUtilRt.find((Object[])this.myOccurrences, (Object)this.myExpression);
        PsiElement[] replaced = this.myProcessUsages ? this.processOccurrences() : this.myOccurrences;
        PsiElement replacedExpression = replaced[expressionIndex];
        GrStatement anchor = GrIntroduceHandlerBase.getAnchor(replaced, this.myContext.getScope());
        RefactoringUtil.highlightAllOccurrences((Project)this.myContext.getProject(), (PsiElement[])replaced, (Editor)this.myContext.getEditor());
        return this.insertVariableDefinition(declaration, anchor, replacedExpression);
    }

    protected abstract void refreshPositionMarker(PsiElement var1);

    private static boolean isControlStatementBranch(GrStatement statement) {
        return statement.getParent() instanceof GrLoopStatement && statement == ((GrLoopStatement)statement.getParent()).getBody() || statement.getParent() instanceof GrIfStatement && (statement == ((GrIfStatement)statement.getParent()).getThenBranch() || statement == ((GrIfStatement)statement.getParent()).getElseBranch());
    }

    private PsiElement[] processOccurrences() {
        ArrayList result2 = ContainerUtil.newArrayList();
        GrReferenceExpression templateRef = GroovyPsiElementFactory.getInstance(this.myContext.getProject()).createReferenceExpressionFromText(this.mySettings.getName());
        for (PsiElement occurrence : this.myOccurrences) {
            if (!(occurrence instanceof GrExpression)) {
                throw new IncorrectOperationException("Expression occurrence to be replaced is not instance of GroovyPsiElement");
            }
            GrExpression replaced = ((GrExpression)occurrence).replaceWithExpression(templateRef, true);
            result2.add(replaced);
        }
        return PsiUtilCore.toPsiElementArray((Collection)result2);
    }

    @NotNull
    private GrExpression preprocessOccurrences() {
        GroovyRefactoringUtil.sortOccurrences(this.myOccurrences);
        if (this.myOccurrences.length == 0 || !(this.myOccurrences[0] instanceof GrExpression)) {
            throw new IncorrectOperationException("Wrong expression occurrence");
        }
        return (GrExpression)this.myOccurrences[0];
    }

    private static void resolveLocalConflicts(@NotNull PsiElement tempContainer, @NotNull String varName) {
        for (PsiElement child : tempContainer.getChildren()) {
            if (child instanceof GrReferenceExpression && !child.getText().contains(".")) {
                String fieldName;
                PsiElement resolved;
                PsiReference psiReference = child.getReference();
                if (psiReference == null || (resolved = psiReference.resolve()) == null || (fieldName = GrIntroduceLocalVariableProcessor.getFieldName(resolved)) == null || !varName.equals(fieldName)) continue;
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(tempContainer.getProject());
                ((GrReferenceExpression)child).replaceWithExpression(factory.createExpressionFromText("this." + child.getText()), true);
                continue;
            }
            GrIntroduceLocalVariableProcessor.resolveLocalConflicts(child, varName);
        }
    }

    @NotNull
    private GrVariable insertVariableDefinition(@NotNull GrVariableDeclaration declaration, @NotNull GrStatement anchor, @Nullable PsiElement expression) throws IncorrectOperationException {
        boolean isInsideControlStatement;
        String usedLabel;
        GrLabeledStatement labeledStatement = expression != null && expression.getParent() instanceof GrLabeledStatement ? (GrLabeledStatement)expression.getParent() : null;
        boolean expressionMustBeDeleted = expression != null && PsiUtil.isExpressionStatement(expression) && !GrIntroduceLocalVariableProcessor.isSingleGStringInjectionExpr(expression);
        boolean anchorEqualsExpression = anchor == expression || labeledStatement == anchor;
        String string = usedLabel = labeledStatement != null ? labeledStatement.getName() : null;
        if (expressionMustBeDeleted && !anchorEqualsExpression) {
            expression.delete();
        }
        if (isInsideControlStatement = GrIntroduceLocalVariableProcessor.isControlStatementBranch(anchor)) {
            anchor = GrIntroduceLocalVariableProcessor.insertBraces(anchor);
        }
        LOG.assertTrue(this.myOccurrences.length > 0);
        GrStatementOwner block = (GrStatementOwner)anchor.getParent();
        if (usedLabel != null && expressionMustBeDeleted && anchorEqualsExpression) {
            GrLabeledStatement definitionWithLabel = (GrLabeledStatement)GroovyPsiElementFactory.getInstance(anchor.getProject()).createStatementFromText(usedLabel + ": foo()");
            GrLabeledStatement inserted = GrIntroduceLocalVariableProcessor.insertStatement(definitionWithLabel, anchor, block, true);
            declaration = inserted.getStatement().replaceWithStatement(declaration);
        } else {
            declaration = GrIntroduceLocalVariableProcessor.insertStatement(declaration, anchor, block, expressionMustBeDeleted && anchorEqualsExpression);
        }
        GrVariable variable = declaration.getVariables()[0];
        JavaCodeStyleManager.getInstance((Project)declaration.getProject()).shortenClassReferences((PsiElement)declaration);
        GrVariable markerPlace = expressionMustBeDeleted ? variable : (isInsideControlStatement ? declaration.getParent() : expression);
        this.refreshPositionMarker(markerPlace);
        return variable;
    }

    private static <T extends GrStatement> T insertStatement(T declaration, GrStatement anchor, GrStatementOwner block, boolean replaceAnchor) {
        if (replaceAnchor) {
            return (T)((GrStatement)anchor.replace(declaration));
        }
        return (T)block.addStatementBefore(declaration, anchor);
    }

    @NotNull
    static GrStatement insertBraces(@NotNull GrStatement anchor) {
        GrBlockStatement blockStatement = GroovyPsiElementFactory.getInstance(anchor.getProject()).createBlockStatement(new GrStatement[0]);
        blockStatement.getBlock().addStatementBefore(anchor, null);
        GrBlockStatement newBlockStatement = (GrBlockStatement)anchor.replace(blockStatement);
        return newBlockStatement.getBlock().getStatements()[0];
    }

    private static boolean isSingleGStringInjectionExpr(PsiElement expression) {
        PsiElement parent2 = expression.getParent();
        return parent2 instanceof GrClosableBlock && parent2.getParent() instanceof GrStringInjection;
    }

    @Nullable
    private static String getFieldName(@Nullable PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        return element instanceof GrField ? ((GrField)element).getName() : null;
    }
}

