/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;
import org.jetbrains.plugins.groovy.refactoring.rename.RenamePropertyUtil;

public class RenameGroovyPropertyProcessor
extends RenamePsiElementProcessor {
    Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.rename.RenameGroovyPropertyProcessor");

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        this.LOG.assertTrue(element instanceof PropertyForRename);
        List<? extends PsiElement> elementsToRename = ((PropertyForRename)element).getElementsToRename();
        for (PsiElement psiElement : elementsToRename) {
            if (psiElement instanceof GrField) {
                allRenames.put(psiElement, newName);
                continue;
            }
            if (!(psiElement instanceof GrMethod)) continue;
            if (GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)psiElement)) {
                allRenames.put(psiElement, RenamePropertyUtil.getGetterNameByOldName(newName, ((PsiMethod)psiElement).getName()));
                continue;
            }
            allRenames.put(psiElement, GroovyPropertyUtils.getSetterName(newName));
        }
        allRenames.remove(element);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PropertyForRename;
    }
}

