/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename.inplace;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrMethodInplaceRenamer
extends MemberInplaceRenamer {
    public GrMethodInplaceRenamer(PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        super(elementToRename, substituted, editor);
    }

    protected boolean isIdentifier(String newName, Language language) {
        return true;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        TextRange range = GrMethodInplaceRenamer.getIdentifierNameRange(element);
        return range != null ? range : super.getRangeToRename(element);
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        TextRange range = GrMethodInplaceRenamer.getReferenceNameRange(reference.getElement());
        return range != null ? range : super.getRangeToRename(reference);
    }

    @Nullable
    private static TextRange getIdentifierNameRange(@NotNull PsiElement element) {
        if (element instanceof JavaIdentifier) {
            return GrStringUtil.getStringContentRange(element.getNavigationElement());
        }
        return null;
    }

    @Nullable
    private static TextRange getReferenceNameRange(PsiElement element) {
        GrReferenceExpression referenceExpression;
        PsiElement nameElement;
        TextRange stringContentRange;
        if (element instanceof GrReferenceExpression && (stringContentRange = GrStringUtil.getStringContentRange(nameElement = (referenceExpression = (GrReferenceExpression)element).getReferenceNameElement())) != null) {
            return stringContentRange.shiftRight(nameElement.getStartOffsetInParent());
        }
        return null;
    }
}

