/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename.inplace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyResolveSnapshot
extends ResolveSnapshotProvider.ResolveSnapshot {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.refactoring.rename.inplace.GroovyResolveSnapshot");
    private final Map<SmartPsiElementPointer, SmartPsiElementPointer> myReferencesMap = new HashMap<SmartPsiElementPointer, SmartPsiElementPointer>();
    private final Project myProject;
    private final Document myDocument;

    public GroovyResolveSnapshot(PsiElement scope) {
        this.myProject = scope.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(scope.getContainingFile());
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        final HashMap pointers = new HashMap();
        scope.accept((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
                PsiElement resolved;
                if (!refExpr.isQualified() && (resolved = refExpr.resolve()) instanceof GrMember) {
                    SmartPsiElementPointer key = pointerManager.createSmartPsiElementPointer((PsiElement)refExpr);
                    SmartPsiElementPointer value = (SmartPsiElementPointer)pointers.get(resolved);
                    if (value == null) {
                        value = pointerManager.createSmartPsiElementPointer(resolved);
                        pointers.put(resolved, value);
                    }
                    GroovyResolveSnapshot.this.myReferencesMap.put(key, value);
                }
                super.visitReferenceExpression(refExpr);
            }
        }));
    }

    public void apply(String hidingLocalName) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        for (Map.Entry<SmartPsiElementPointer, SmartPsiElementPointer> entry : this.myReferencesMap.entrySet()) {
            GroovyResolveSnapshot.qualify(entry.getKey().getElement(), entry.getValue().getElement(), hidingLocalName);
        }
    }

    private static void qualify(PsiElement referent, PsiElement referee, String hidingLocalName) {
        GrReferenceExpression ref;
        if (referent instanceof GrReferenceExpression && referee instanceof GrMember && !(ref = (GrReferenceExpression)referent).isQualified() && hidingLocalName.equals(ref.getReferenceName())) {
            PsiUtil.qualifyMemberReference(ref, (GrMember)referee, hidingLocalName);
        }
    }
}

