/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

public final class GroovyScriptRunConfigurationType
implements ConfigurationType {
    private final GroovyFactory myConfigurationFactory = new GroovyFactory(this);

    @NotNull
    public String getDisplayName() {
        return "Groovy";
    }

    public String getConfigurationTypeDescription() {
        return "Groovy Class or Script";
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    @NonNls
    @NotNull
    public String getId() {
        return "GroovyScriptRunConfiguration";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myConfigurationFactory};
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.GroovyScriptRunConfiguration";
    }

    public static GroovyScriptRunConfigurationType getInstance() {
        return (GroovyScriptRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(GroovyScriptRunConfigurationType.class);
    }

    private static class GroovyFactory
    extends ConfigurationFactory {
        GroovyFactory(ConfigurationType type2) {
            super(type2);
        }

        public boolean isApplicable(@NotNull Project project) {
            return FileTypeIndex.containsFileOfType((FileType)GroovyFileType.GROOVY_FILE_TYPE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new GroovyScriptRunConfiguration("Groovy Script", project, this);
        }
    }
}

