/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class BaseScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (!(context.getCodeClass() instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)context.getCodeClass();
        LightMethodBuilder mainMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "main").setMethodReturnType((PsiType)PsiType.VOID).addParameter("args", (PsiType)new PsiArrayType((PsiType)PsiType.getJavaLangString((PsiManager)scriptClass.getManager(), (GlobalSearchScope)scriptClass.getResolveScope()))).addModifiers(new String[]{"public", "static"});
        LightMethodBuilder runMethod = new LightMethodBuilder(scriptClass.getManager(), (Language)GroovyLanguage.INSTANCE, "run").setMethodReturnType((PsiType)TypesUtil.getJavaLangObject(scriptClass)).addModifier("public");
        context.addMethod((PsiMethod)runMethod, true);
        context.addMethod((PsiMethod)mainMethod, true);
        context.setSuperType(BaseScriptTransformationSupport.getBaseClassType(scriptClass));
    }

    @NotNull
    private static PsiClassType getBaseClassType(@NotNull GroovyScriptClass scriptClass) {
        PsiClassType type2 = BaseScriptTransformationSupport.getSuperClassTypeFromBaseScriptAnnotatedVariable(scriptClass);
        if (type2 != null) {
            return type2;
        }
        PsiClassType superClassFromDSL = GroovyDslFileIndex.processScriptSuperClasses(scriptClass.getContainingFile());
        if (superClassFromDSL != null) {
            return superClassFromDSL;
        }
        return TypesUtil.createTypeByFQClassName("groovy.lang.Script", scriptClass);
    }

    @Nullable
    private static PsiClassType getSuperClassTypeFromBaseScriptAnnotatedVariable(GroovyScriptClass scriptClass) {
        return (PsiClassType)CachedValuesManager.getCachedValue((PsiElement)scriptClass, () -> CachedValueProvider.Result.create((Object)BaseScriptTransformationSupport.doGetSuperClassType(scriptClass), (Object[])new Object[]{scriptClass.getContainingFile()}));
    }

    private static PsiClassType doGetSuperClassType(GroovyScriptClass scriptClass) {
        PsiType type2;
        GrTypeElement typeElement;
        GrVariableDeclaration declaration = BaseScriptTransformationSupport.findDeclaration(scriptClass.getContainingFile());
        if (declaration != null && (typeElement = declaration.getTypeElementGroovy()) != null && (type2 = typeElement.getType()) instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        return null;
    }

    @Nullable
    private static GrVariableDeclaration findDeclaration(GroovyFile file) {
        if (!IdIndex.hasIdentifierInFile((PsiFile)file, (String)"BaseScript")) {
            return null;
        }
        for (GrVariableDeclaration declaration : file.getScriptDeclarations(false)) {
            if (!declaration.getModifierList().hasAnnotation("groovy.transform.BaseScript")) continue;
            return declaration;
        }
        return null;
    }
}

