/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class FieldScriptTransformationSupport
implements AstTransformationSupport {
    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        if (!(context.getCodeClass() instanceof GroovyScriptClass)) {
            return;
        }
        GroovyScriptClass scriptClass = (GroovyScriptClass)context.getCodeClass();
        GroovyFile containingFile = scriptClass.getContainingFile();
        if (GrFileIndexUtil.isGroovySourceFile(containingFile) && !IdIndex.hasIdentifierInFile((PsiFile)containingFile, (String)"Field")) {
            return;
        }
        for (GrVariableDeclaration declaration : containingFile.getScriptDeclarations(true)) {
            if (!declaration.getModifierList().hasAnnotation("groovy.transform.Field")) continue;
            for (GrVariable variable : declaration.getVariables()) {
                context.addField(new GrScriptField(variable, scriptClass));
            }
        }
    }
}

