/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.unwrap.GroovyUnwrapper;

public class GroovyConditionalUnwrapper
extends GroovyUnwrapper {
    public GroovyConditionalUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.conditional", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e.getParent() instanceof GrConditionalExpression;
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return e.getParent();
    }

    protected void doUnwrap(PsiElement element, GroovyUnwrapper.Context context) throws IncorrectOperationException {
        GrConditionalExpression cond = (GrConditionalExpression)element.getParent();
        Object savedBlock = cond.getElseBranch() == element ? element : cond.getThenBranch();
        context.extractElement((PsiElement)savedBlock, cond);
        context.deleteExactly(cond);
    }
}

