/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.PairFunction;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyStdTypeCalculators {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"GrDescriptorReturnTypeCalculator getClosureReturnType");

    private GroovyStdTypeCalculators() {
    }

    public static class TypeSameAsFirstArgument
    implements PairFunction<GrMethodCall, PsiMethod, PsiType> {
        public PsiType fun(GrMethodCall methodCall, PsiMethod method) {
            GrArgumentList argumentList = methodCall.getArgumentList();
            GrExpression[] arguments2 = argumentList.getExpressionArguments();
            if (arguments2.length == 0) {
                return null;
            }
            return arguments2[0].getType();
        }
    }

    public static class ClosureTypeExtractor
    implements PairFunction<GrMethodCall, PsiMethod, PsiType> {
        public PsiType fun(GrMethodCall methodCall, PsiMethod method) {
            GrExpression[] allArguments = PsiUtil.getAllArguments(methodCall);
            GrClosableBlock closure = null;
            for (GrExpression argument : allArguments) {
                if (!(argument instanceof GrClosableBlock)) continue;
                closure = (GrClosableBlock)argument;
                break;
            }
            if (closure == null) {
                return null;
            }
            GrClosableBlock finalClosure = closure;
            return (PsiType)ourGuard.doPreventingRecursion((Object)methodCall, true, (Computable)((NullableComputable)() -> {
                PsiType returnType2 = finalClosure.getReturnType();
                if (PsiType.VOID.equals((Object)returnType2)) {
                    return null;
                }
                return returnType2;
            }));
        }
    }
}

