/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public abstract class GroovyUtils {
    public static File[] getFilesInDirectoryByPattern(String dirPath, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        return LibrariesUtil.getFilesInDirectoryByPattern(dirPath, pattern);
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@NotNull Project project, @NotNull VirtualFile file) {
        return GroovyUtils.getPublicClass(file, PsiManager.getInstance((Project)project));
    }

    @Nullable
    public static GrTypeDefinition getPublicClass(@Nullable VirtualFile virtualFile, @NotNull PsiManager manager) {
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = manager.findFile(virtualFile);
        if (psiFile instanceof PsiCompiledFile) {
            psiFile = psiFile.getNavigationElement();
        }
        if (psiFile instanceof GroovyFile) {
            return GroovyUtils.getClassDefinition((GroovyFile)psiFile);
        }
        return null;
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile) {
        String fileName = groovyFile.getName();
        int idx = fileName.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        return GroovyUtils.getClassDefinition(groovyFile, fileName.substring(0, idx));
    }

    @Nullable
    public static GrTypeDefinition getClassDefinition(@NotNull GroovyFile groovyFile, @NotNull String classSimpleName) {
        for (GrTypeDefinition definition : groovyFile.getTypeDefinitions()) {
            if (!classSimpleName.equals(definition.getName())) continue;
            return definition;
        }
        return null;
    }
}

