/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    private static boolean assertOnMissedKeys = false;

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, null, params);
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value;
        block5: {
            if (bundle == null) {
                return defaultValue;
            }
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                if (defaultValue != null) {
                    value = defaultValue;
                }
                value = "!" + key + "!";
                if (!assertOnMissedKeys || $assertionsDisabled) break block5;
                throw new AssertionError((Object)("'" + key + "' is not found in " + bundle));
            }
        }
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
            OrdinalFormat.apply(format);
            value = format.format(params);
        }
        return value;
    }

    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        return params.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params) : value;
    }

    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

