/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProcessHandler<T extends Process>
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseProcessHandler.class);
    protected final T myProcess;
    protected final String myCommandLine;
    protected final Charset myCharset;
    protected final String myPresentableName;
    protected final ProcessWaitFor myWaitFor;

    public BaseProcessHandler(@NotNull T process, String commandLine, @Nullable Charset charset) {
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myCharset = charset;
        if (StringUtil.isEmpty(commandLine)) {
            LOG.warn(new IllegalArgumentException("Must specify non-empty 'commandLine' parameter"));
        }
        this.myPresentableName = CommandLineUtil.extractPresentableName(StringUtil.notNullize(commandLine));
        this.myWaitFor = new ProcessWaitFor((Process)process, this, this.myPresentableName);
    }

    @NotNull
    public final T getProcess() {
        return this.myProcess;
    }

    public String getCommandLine() {
        return this.myCommandLine;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @Override
    public OutputStream getProcessInput() {
        return ((Process)this.myProcess).getOutputStream();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected void doDestroyProcess() {
        ((Process)this.getProcess()).destroy();
    }

    @Override
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    @Override
    protected void detachProcessImpl() {
        Runnable runnable = () -> {
            this.closeStreams();
            this.myWaitFor.detach();
            this.notifyProcessDetached();
        };
        this.executeTask(runnable);
    }

    @Override
    public boolean detachIsDefault() {
        return false;
    }

    protected void closeStreams() {
        try {
            ((Process)this.myProcess).getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }
}

