/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.util.concurrency.CountingThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ProcessIOExecutorService
extends ThreadPoolExecutor {
    public static final String POOLED_THREAD_PREFIX = "Process I/O pool ";
    public static final ExecutorService INSTANCE = new ProcessIOExecutorService();

    private ProcessIOExecutorService() {
        super(1, Integer.MAX_VALUE, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new CountingThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, ProcessIOExecutorService.POOLED_THREAD_PREFIX + this.counter.incrementAndGet());
                thread.setPriority(4);
                return thread;
            }
        });
    }

    public int getThreadCounter() {
        return ((CountingThreadFactory)this.getThreadFactory()).getCount();
    }
}

