/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutputType
extends Key {
    private final ProcessOutputType myStreamType;

    public ProcessOutputType(@NotNull String name, @NotNull ProcessOutputType streamType) {
        super(name);
        this.myStreamType = streamType.getBaseOutputType();
    }

    ProcessOutputType(@NotNull String name) {
        super(name);
        this.myStreamType = null;
    }

    @NotNull
    public ProcessOutputType getBaseOutputType() {
        return this.myStreamType != null ? this.myStreamType : this;
    }

    public boolean isStdout() {
        return this.getBaseOutputType() == ProcessOutputTypes.STDOUT;
    }

    public boolean isStderr() {
        return this.getBaseOutputType() == ProcessOutputTypes.STDERR;
    }

    public static boolean isStderr(@NotNull Key key) {
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStderr();
    }

    public static boolean isStdout(@NotNull Key key) {
        return key instanceof ProcessOutputType && ((ProcessOutputType)key).isStdout();
    }

    @NotNull
    public static String getKeyNameForLogging(@NotNull Key key) {
        return key.toString().replace("\u001b", "ESC");
    }

    @Nullable
    public static ProcessOutputType tryCast(@NotNull Key key) {
        return key instanceof ProcessOutputType ? (ProcessOutputType)key : null;
    }
}

