/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.TaskExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ProcessWaitFor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.ProcessWaitFor");
    private final Future<?> myWaitForThreadFuture;
    private final BlockingQueue<Consumer<Integer>> myTerminationCallback = new ArrayBlockingQueue<Consumer<Integer>>(1);
    private volatile boolean myDetached;

    @Deprecated
    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor) {
        this(process, executor, "");
    }

    public ProcessWaitFor(@NotNull Process process, @NotNull TaskExecutor executor, @NotNull String presentableName) {
        this.myWaitForThreadFuture = executor.executeTask(() -> {
            String threadName = StringUtil.isEmptyOrSpaces(presentableName) ? Thread.currentThread().getName() : presentableName;
            ConcurrencyUtil.runUnderThreadName(threadName, () -> {
                int exitCode = 0;
                try {
                    while (!this.myDetached) {
                        try {
                            exitCode = process.waitFor();
                            break;
                        }
                        catch (InterruptedException e) {
                            if (this.myDetached) continue;
                            LOG.debug(e);
                        }
                    }
                }
                finally {
                    if (!this.myDetached) {
                        try {
                            this.myTerminationCallback.take().consume(exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.info(e);
                        }
                    }
                }
            });
        });
    }

    public void detach() {
        this.myDetached = true;
        this.myWaitForThreadFuture.cancel(true);
    }

    public void setTerminationCallback(@NotNull Consumer<Integer> r) {
        this.myTerminationCallback.offer(r);
    }

    public void waitFor() throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get();
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
    }

    public boolean waitFor(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        try {
            this.myWaitForThreadFuture.get(timeout, unit);
        }
        catch (ExecutionException e) {
            LOG.error(e);
        }
        catch (CancellationException | TimeoutException exception) {
            // empty catch block
        }
        return this.myWaitForThreadFuture.isDone();
    }
}

