/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.util.containers.ContainerUtilRt;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObject
implements Remote,
Unreferenced {
    private final WeakReference<RemoteObject> myWeakRef;
    private RemoteObject myParent;
    private final Map<RemoteObject, Remote> myChildren = new ConcurrentHashMap<RemoteObject, Remote>();

    public RemoteObject() {
        this.myWeakRef = new WeakReference<RemoteObject>(this);
    }

    public WeakReference<RemoteObject> getWeakRef() {
        return this.myWeakRef;
    }

    @Contract(value="!null->!null")
    public synchronized <T extends Remote> T export(@Nullable T child) throws RemoteException {
        if (child == null) {
            return null;
        }
        Remote result = UnicastRemoteObject.exportObject(child, 0);
        this.myChildren.put((RemoteObject)child, result);
        ((RemoteObject)child).myParent = this;
        return (T)result;
    }

    @Contract(value="!null->!null")
    public <T extends Remote> T export2(@Nullable T child) throws RemoteException {
        return this.export(child);
    }

    public synchronized void unexportChildren() throws RemoteException {
        ArrayList<RemoteObject> childrenRefs = new ArrayList<RemoteObject>(this.myChildren.keySet());
        this.myChildren.clear();
        for (RemoteObject child : childrenRefs) {
            child.unreferenced();
        }
    }

    public synchronized void unexportChildren(@NotNull Collection<WeakReference<RemoteObject>> children) throws RemoteException {
        if (children.isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(children.size());
        for (WeakReference<RemoteObject> weakReference : children) {
            ContainerUtilRt.addIfNotNull(list, weakReference.get());
        }
        this.myChildren.keySet().removeAll(list);
        for (RemoteObject remoteObject : list) {
            remoteObject.unreferenced();
        }
    }

    @Override
    public synchronized void unreferenced() {
        if (this.myParent != null) {
            this.myParent.myChildren.remove(this);
            this.myParent = null;
            try {
                this.unexportChildren();
                UnicastRemoteObject.unexportObject(this, false);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public Throwable wrapException(Throwable ex) {
        boolean foreignException = false;
        for (Throwable each = ex; each != null; each = each.getCause()) {
            if (each.getClass().getName().startsWith("java.") || this.isKnownException(each)) continue;
            foreignException = true;
            break;
        }
        if (foreignException) {
            RuntimeException wrapper = new RuntimeException(ex.toString());
            wrapper.setStackTrace(ex.getStackTrace());
            wrapper.initCause(this.wrapException(ex.getCause()));
            ex = wrapper;
        }
        return ex;
    }

    protected boolean isKnownException(Throwable ex) {
        return false;
    }

    protected Iterable<RemoteObject> getExportedChildren() {
        return this.myChildren.keySet();
    }
}

