/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.rmi.RemoteDeadHand;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.Hashtable;
import java.util.Random;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServer {
    public static final String SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static Remote ourRemote;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void start(Remote remote) throws Exception {
        Registry registry;
        int port;
        RemoteServer.setupRMI();
        RemoteServer.banJNDI();
        RemoteServer.setupSSL();
        if (ourRemote != null) {
            throw new AssertionError((Object)"Already started");
        }
        ourRemote = remote;
        RMISocketFactory clientSocketFactory = RMISocketFactory.getDefaultSocketFactory();
        RMIServerSocketFactory serverSocketFactory = new RMIServerSocketFactory(){
            final InetAddress loopbackAddress = InetAddress.getByName(RemoteServer.access$000());

            public ServerSocket createServerSocket(int port) throws IOException {
                return new ServerSocket(port, 0, this.loopbackAddress);
            }
        };
        Random random = new Random();
        while (true) {
            if ((port = random.nextInt(65535)) < 4000) {
                continue;
            }
            try {
                registry = LocateRegistry.createRegistry(port, clientSocketFactory, serverSocketFactory);
            }
            catch (ExportException exportException) {
                continue;
            }
            break;
        }
        try {
            Remote stub = UnicastRemoteObject.exportObject(ourRemote, 0);
            String name = remote.getClass().getSimpleName() + Integer.toHexString(stub.hashCode());
            registry.bind(name, stub);
            String id = port + "/" + name;
            System.out.println("Port/ID: " + id);
            long waitTime = 20000L;
            Object lock = new Object();
            while (true) {
                Object object = lock;
                synchronized (object) {
                    lock.wait(waitTime);
                }
                RemoteDeadHand deadHand = (RemoteDeadHand)registry.lookup("_DEAD_HAND_");
                waitTime = deadHand.ping(id);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
    }

    public static void setupRMI() {
        if (System.getProperty(SERVER_HOSTNAME) == null) {
            System.setProperty(SERVER_HOSTNAME, RemoteServer.getLoopbackAddress());
        }
        System.setProperty("java.rmi.server.disableHttp", "true");
    }

    private static void banJNDI() {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", "com.intellij.execution.rmi.RemoteServer$Jndi");
        }
    }

    private static void setupSSL() {
        boolean clientKey;
        boolean caCert = System.getProperty("sslCaCertPath") != null;
        boolean clientCert = System.getProperty("sslClientCertPath") != null;
        boolean bl = clientKey = System.getProperty("sslClientKeyPath") != null;
        if (caCert || clientCert && clientKey) {
            Security.setProperty("ssl.SocketFactory.provider", "com.intellij.execution.rmi.ssl.SslSocketFactory");
        }
    }

    @NotNull
    private static String getLoopbackAddress() {
        boolean ipv6 = false;
        try {
            ipv6 = InetAddress.getByName(null) instanceof Inet6Address;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ipv6 ? "::1" : "127.0.0.1";
    }

    static /* synthetic */ String access$000() {
        return RemoteServer.getLoopbackAddress();
    }

    static {
        System.setProperty("apple.awt.UIElement", "true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Jndi
    implements InitialContextFactory,
    InvocationHandler {
        @Override
        @NotNull
        public Context getInitialContext(Hashtable<?, ?> environment) {
            return (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)this);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, args);
            }
            throw new NamingException("JNDI service is disabled");
        }
    }
}

